/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geobatch.actions.tools.adapter;

import it.geosolutions.geobatch.actions.tools.adapter.EventAdapter;
import it.geosolutions.geobatch.configuration.event.action.ActionConfiguration;
import it.geosolutions.geobatch.flow.event.action.Action;
import it.geosolutions.geobatch.flow.event.action.ActionException;
import it.geosolutions.geobatch.flow.event.action.BaseAction;
import java.io.IOException;
import java.util.EventObject;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdapterAction<T extends EventObject>
extends BaseAction<EventObject>
implements EventAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AdapterAction.class.toString());

    protected AdapterAction(ActionConfiguration configuration) throws IOException {
        super(configuration);
    }

    public Queue<EventObject> execute(Queue<EventObject> events) throws ActionException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting with processing...");
        }
        if (events.size() > 0) {
            LinkedBlockingQueue<EventObject> queue = new LinkedBlockingQueue<EventObject>();
            while (!events.isEmpty()) {
                EventObject event = events.remove();
                if ((event = this.adapter(event)) != null) {
                    queue.add(event);
                    continue;
                }
                throw new ActionException((Action)this, "Passed event is not a FileSystemEvent instance");
            }
            return queue;
        }
        throw new IllegalArgumentException("Wrong number of elements for this action: " + events.size());
    }
}

