/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geobatch.services.rest.impl;

import it.geosolutions.geobatch.catalog.Catalog;
import it.geosolutions.geobatch.catalog.file.DataDirHandler;
import it.geosolutions.geobatch.flow.event.IProgressListener;
import it.geosolutions.geobatch.flow.event.ProgressListener;
import it.geosolutions.geobatch.flow.event.action.BaseAction;
import it.geosolutions.geobatch.flow.event.consumer.BaseEventConsumer;
import it.geosolutions.geobatch.flow.event.consumer.EventConsumer;
import it.geosolutions.geobatch.flow.event.consumer.EventConsumerDetails;
import it.geosolutions.geobatch.flow.event.consumer.EventConsumerStatus;
import it.geosolutions.geobatch.flow.event.consumer.file.FileBasedEventConsumer;
import it.geosolutions.geobatch.flow.event.listeners.cumulator.CumulatingProgressListener;
import it.geosolutions.geobatch.flow.event.listeners.status.StatusProgressListener;
import it.geosolutions.geobatch.flow.file.FileBasedFlowManager;
import it.geosolutions.geobatch.services.rest.RESTFlowService;
import it.geosolutions.geobatch.services.rest.exception.BadRequestRestEx;
import it.geosolutions.geobatch.services.rest.exception.InternalErrorRestEx;
import it.geosolutions.geobatch.services.rest.exception.NotFoundRestEx;
import it.geosolutions.geobatch.services.rest.impl.runutils.FlowRunner;
import it.geosolutions.geobatch.services.rest.impl.utils.RESTUtils;
import it.geosolutions.geobatch.services.rest.model.RESTActionShort;
import it.geosolutions.geobatch.services.rest.model.RESTConsumerList;
import it.geosolutions.geobatch.services.rest.model.RESTConsumerShort;
import it.geosolutions.geobatch.services.rest.model.RESTConsumerStatus;
import it.geosolutions.geobatch.services.rest.model.RESTFlow;
import it.geosolutions.geobatch.services.rest.model.RESTFlowList;
import it.geosolutions.geobatch.services.rest.model.RESTRunInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTFileBasedFlowServiceImpl
implements RESTFlowService {
    private static Logger LOGGER = LoggerFactory.getLogger(RESTFileBasedFlowServiceImpl.class);
    private Catalog catalog;
    private DataDirHandler dataDirHandler;
    public static final String REST_INPUT_DIR = "rest_input";

    public RESTFlowList getFlowList() throws InternalErrorRestEx {
        return RESTUtils.convertFlowList(this.getAuthFlowManagers());
    }

    public RESTFlow getFlow(String flowId) throws NotFoundRestEx, InternalErrorRestEx {
        FileBasedFlowManager flowManager = this.getAuthFlowManager(flowId);
        if (flowManager == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Flow not found: " + flowId);
            }
            throw new NotFoundRestEx("Flow not found: " + flowId);
        }
        return RESTUtils.convertFlow(flowManager);
    }

    public String run(String flowId, Boolean fastfail, String fileName, byte[] data) throws BadRequestRestEx, InternalErrorRestEx {
        FileBasedFlowManager flowMan;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Running instance of flow " + flowId);
        }
        if ((flowMan = this.getAuthFlowManager(flowId)) == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Flow not found: " + flowId);
            }
            throw new NotFoundRestEx("Flow not found: " + flowId);
        }
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        File eventFile = null;
        try {
            if (fileName == null || fileName.isEmpty()) {
                fileName = "inputConfig" + System.currentTimeMillis() + ".tmp";
            }
            eventFile = new File(flowMan.getFlowTempDir() + File.separator + fileName.toString());
            LOGGER.warn("Creating temp input file " + eventFile + " . THIS FILE SHOULD BE PLACED SOMEWHERE ELSE");
            os = new FileOutputStream(eventFile);
            bos = new BufferedOutputStream(os);
            bos.write(data);
            bos.flush();
        }
        catch (Exception e) {
            try {
                throw new InternalErrorRestEx(e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)os);
        FlowRunner fr = new FlowRunner(flowMan, this.dataDirHandler);
        FileBasedEventConsumer consumer = null;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Creating new consumer for flow " + flowId);
            }
            consumer = fr.createConsumer();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Starting the consumer " + flowId + "::" + consumer.getId());
            }
            fr.runConsumer(consumer.getId(), Collections.singletonList(eventFile));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InternalErrorRestEx(e.getMessage());
        }
        return consumer.getId();
    }

    public String runLocal(String flowId, Boolean fastfail, RESTRunInfo info) throws BadRequestRestEx, InternalErrorRestEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Running instance of flow " + flowId + " -- " + info);
        }
        if (info.getFileList() == null || info.size() == 0) {
            throw new BadRequestRestEx("No file provided");
        }
        FileBasedFlowManager flowMan = this.getAuthFlowManager(flowId);
        if (flowMan == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Flow not found: " + flowId);
            }
            throw new NotFoundRestEx("Flow not found: " + flowId);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        HashSet<String> filenames = new HashSet<String>();
        for (String filepath : info) {
            File file = new File(filepath);
            if (!file.exists()) {
                LOGGER.warn("File not found " + filepath);
                throw new NotFoundRestEx("File not found");
            }
            String name = file.getName();
            if (filenames.contains(name)) {
                throw new BadRequestRestEx("Duplicated names in list");
            }
            filenames.add(name);
            fileList.add(file);
        }
        FlowRunner fr = new FlowRunner(flowMan, this.dataDirHandler);
        FileBasedEventConsumer consumer = null;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Creating new consumer for flow " + flowId);
            }
            consumer = fr.createConsumer();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Starting the consumer " + flowId + "::" + consumer.getId());
            }
            List<File> copiedFiles = RESTFileBasedFlowServiceImpl.createWorkCopy(fileList, consumer.getFlowInstanceTempDir());
            fr.runConsumer(consumer.getId(), copiedFiles);
        }
        catch (InternalErrorRestEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InternalErrorRestEx(e.getMessage());
        }
        return consumer.getId();
    }

    private static List<File> createWorkCopy(List<File> fileList, File flowInstanceTempDir) throws InternalErrorRestEx {
        File dstDir = new File(flowInstanceTempDir, REST_INPUT_DIR);
        ArrayList<File> ret = new ArrayList<File>(fileList.size());
        try {
            for (File file : fileList) {
                File dstFile = new File(dstDir, file.getName());
                FileUtils.copyFile((File)file, (File)dstFile);
                ret.add(dstFile);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InternalErrorRestEx("Error while copying files");
        }
        return ret;
    }

    public RESTConsumerList getFlowConsumers(String flowId, boolean includeDetails) throws NotFoundRestEx, InternalErrorRestEx {
        FileBasedFlowManager flowManager;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Searching consumers for flow '" + flowId + "' ");
        }
        if ((flowManager = this.getAuthFlowManager(flowId)) == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Flow not found: " + flowId);
            }
            throw new NotFoundRestEx("Flow not found: " + flowId);
        }
        RESTConsumerList rcl = new RESTConsumerList();
        for (BaseEventConsumer bec : flowManager.getEventConsumers()) {
            RESTConsumerShort rcs = new RESTConsumerShort();
            rcs.setUuid(bec.getId());
            rcs.setStatus(RESTUtils.convertStatus(bec.getStatus()));
            rcs.setStartDate(RESTUtils.formatDate(bec.getCreationTimestamp()));
            rcs.setDescription(bec.toString());
            if (includeDetails) {
                EventConsumerDetails details = bec.getDetails();
                rcs.setDetails(JSONSerializer.toJSON((Object)details).toString());
            }
            rcl.add(rcs);
        }
        return rcl;
    }

    public RESTConsumerStatus getConsumerStatus(String consumerId) throws NotFoundRestEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Get consumer Status");
        }
        BaseEventConsumer bec = this.getConsumer(consumerId);
        RESTConsumerStatus rcs = new RESTConsumerStatus();
        rcs.setUuid(bec.getId());
        rcs.setStatus(RESTUtils.convertStatus(bec.getStatus()));
        rcs.setExtendedStatus(RESTUtils.getExtStatus(bec.getStatus()));
        if (bec.getStatus().equals((Object)RESTConsumerStatus.Status.FAIL)) {
            rcs.setErrorMessage("property ErrorMessage: Not Implemented yet");
        }
        BaseAction currentAction = (BaseAction)bec.getCurrentAction();
        RESTActionShort lras = new RESTActionShort();
        lras.setId(currentAction.getId());
        lras.setName(currentAction.getName());
        lras.setDescription(currentAction.getDescription());
        rcs.setLatestAction(lras);
        return rcs;
    }

    public String getConsumerLog(String consumerId) throws NotFoundRestEx {
        BaseEventConsumer bec;
        Collection coll;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Get consumer log");
        }
        if ((coll = (bec = this.getConsumer(consumerId)).getListeners()) != null && coll.isEmpty() && LOGGER.isInfoEnabled()) {
            LOGGER.info("No listeners found for consumer " + consumerId);
        }
        StringBuilder sb = new StringBuilder();
        for (IProgressListener listener : coll) {
            if (listener == null) continue;
            if (listener instanceof CumulatingProgressListener) {
                CumulatingProgressListener cpl = (CumulatingProgressListener)listener;
                for (String msg : cpl.getMessages()) {
                    sb.append("Consumer: ").append(msg).append("\n");
                }
                continue;
            }
            if (listener instanceof StatusProgressListener) {
                StatusProgressListener spl = (StatusProgressListener)listener;
                sb.append("Consumer status: ").append(spl.toString()).append("\n");
                continue;
            }
            if (!(listener instanceof ProgressListener)) continue;
            ProgressListener anypl = (ProgressListener)listener;
            sb.append("Consumer action task: ").append(anypl.getTask()).append("\n");
            sb.append("Consumer action progress: ").append(anypl.getProgress()).append("%").append("\n");
        }
        return sb.toString();
    }

    public void pauseConsumer(String consumerId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pausing consumer " + consumerId);
        }
        BaseEventConsumer bec = this.getConsumer(consumerId);
        bec.pause();
    }

    public void resumeConsumer(String consumerId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resuming consumer " + consumerId);
        }
        BaseEventConsumer bec = this.getConsumer(consumerId);
        bec.resume();
    }

    public void cleanupConsumer(String consumerId) throws BadRequestRestEx {
        ConsumerInfo consumerInfo;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cleaning consumer " + consumerId);
        }
        if ((consumerInfo = this.findConsumer(consumerId)) == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Consumer not found: " + consumerId);
            }
            throw new NotFoundRestEx("Consumer not found: " + consumerId);
        }
        BaseEventConsumer bec = consumerInfo.bec;
        FileBasedFlowManager flowManager = consumerInfo.flowManager;
        EventConsumerStatus ecs = bec.getStatus();
        if (!(ecs.equals((Object)EventConsumerStatus.COMPLETED) || ecs.equals((Object)EventConsumerStatus.CANCELED) || ecs.equals((Object)EventConsumerStatus.FAILED))) {
            throw new BadRequestRestEx("Consumer not in a cleanable status");
        }
        flowManager.disposeConsumer((EventConsumer)bec);
    }

    private List<FileBasedFlowManager> getAuthFlowManagers() {
        return RESTUtils.getFlowManagerList(this.catalog);
    }

    private FileBasedFlowManager getAuthFlowManager(String flowId) {
        return RESTUtils.getFlowManager(this.catalog, flowId);
    }

    private BaseEventConsumer getConsumer(String consumerId) throws NotFoundRestEx {
        ConsumerInfo consumerInfo = this.findConsumer(consumerId);
        if (consumerInfo == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Consumer not found: " + consumerId);
            }
            throw new NotFoundRestEx("Consumer not found: " + consumerId);
        }
        return consumerInfo.bec;
    }

    private ConsumerInfo findConsumer(String consumerId) {
        List<FileBasedFlowManager> flowManagerList = this.getAuthFlowManagers();
        BaseEventConsumer bec = null;
        for (FileBasedFlowManager flowManager : flowManagerList) {
            bec = (BaseEventConsumer)flowManager.getConsumer(consumerId);
            if (bec == null) continue;
            ConsumerInfo ret = new ConsumerInfo();
            ret.bec = bec;
            ret.flowManager = flowManager;
            return ret;
        }
        return null;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setDataDirHandler(DataDirHandler dataDirHandler) {
        this.dataDirHandler = dataDirHandler;
    }

    static class ConsumerInfo {
        BaseEventConsumer bec;
        FileBasedFlowManager flowManager;

        ConsumerInfo() {
        }
    }
}

