/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geobatch.services.rest.impl.runutils;

import it.geosolutions.filesystemmonitor.monitor.FileSystemEvent;
import it.geosolutions.filesystemmonitor.monitor.FileSystemEventType;
import it.geosolutions.geobatch.catalog.Identifiable;
import it.geosolutions.geobatch.catalog.file.DataDirHandler;
import it.geosolutions.geobatch.configuration.event.consumer.EventConsumerConfiguration;
import it.geosolutions.geobatch.configuration.event.consumer.file.FileBasedEventConsumerConfiguration;
import it.geosolutions.geobatch.configuration.event.listener.ProgressListenerConfiguration;
import it.geosolutions.geobatch.configuration.event.listener.ProgressListenerService;
import it.geosolutions.geobatch.configuration.flow.file.FileBasedFlowConfiguration;
import it.geosolutions.geobatch.flow.event.IProgressListener;
import it.geosolutions.geobatch.flow.event.ProgressListener;
import it.geosolutions.geobatch.flow.event.consumer.EventConsumer;
import it.geosolutions.geobatch.flow.event.consumer.file.FileBasedEventConsumer;
import it.geosolutions.geobatch.flow.file.FileBasedFlowManager;
import it.geosolutions.geobatch.global.CatalogHolder;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRunner {
    private static Logger LOGGER = LoggerFactory.getLogger(FlowRunner.class);
    private FileBasedFlowManager flowManager;
    private DataDirHandler dataDirHandler;

    public FlowRunner(FileBasedFlowManager fbfm, DataDirHandler dataDirHandler) {
        this.flowManager = fbfm;
        this.dataDirHandler = dataDirHandler;
    }

    public FileBasedEventConsumer createConsumer() throws Exception {
        if (this.flowManager == null || this.flowManager.getConfiguration() == null) {
            throw new IllegalArgumentException("Unable to work with null configuration");
        }
        EventConsumerConfiguration ecc = ((FileBasedFlowConfiguration)this.flowManager.getConfiguration()).getEventConsumerConfiguration();
        List actions = ecc.getActions();
        FileBasedEventConsumerConfiguration consumerConfig = new FileBasedEventConsumerConfiguration("RESTCreatedConsumer");
        consumerConfig.setActions(actions);
        consumerConfig.setListenerId(ecc.getListenerIds());
        consumerConfig.setPreserveInput(true);
        File configDir = FileBasedFlowManager.initConfigDir((FileBasedFlowConfiguration)((FileBasedFlowConfiguration)this.flowManager.getConfiguration()), (File)this.dataDirHandler.getBaseConfigDirectory());
        File tempDir = FileBasedFlowManager.initTempDir((FileBasedFlowConfiguration)((FileBasedFlowConfiguration)this.flowManager.getConfiguration()), (File)this.dataDirHandler.getBaseTempDirectory());
        FileBasedEventConsumer consumer = new FileBasedEventConsumer(consumerConfig, configDir, tempDir);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("INIT injecting consumer to the parent flow. UUID: " + consumer.getId());
        }
        for (ProgressListenerConfiguration plConfig : ecc.getListenerConfigurations()) {
            String serviceID = plConfig.getServiceID();
            ProgressListenerService progressListenerService = (ProgressListenerService)CatalogHolder.getCatalog().getResource(serviceID, ProgressListenerService.class);
            if (progressListenerService == null) continue;
            ProgressListener progressListener = progressListenerService.createProgressListener(plConfig, (Identifiable)consumer);
            consumer.addListener((IProgressListener)progressListener);
        }
        if (!this.flowManager.addConsumer((EventConsumer)consumer)) {
            consumer.dispose();
            throw new IllegalStateException("Unable to add another consumer, consumer queue is full. Please dispose some completed consumer before submit a new one.");
        }
        return consumer;
    }

    public void runConsumer(String uuid, List<File> fileList) throws Exception {
        if (uuid == null || fileList == null) {
            throw new IllegalArgumentException("Unable to run using null arguments: uuid=" + uuid + " event=" + fileList);
        }
        if (fileList.isEmpty()) {
            throw new IllegalArgumentException("Unable to run using empty event list: uuid=" + uuid);
        }
        EventConsumer consumer = this.getConsumer(uuid);
        for (File file : fileList) {
            consumer.consume((EventObject)new FileSystemEvent(file, FileSystemEventType.FILE_ADDED));
        }
        this.flowManager.getExecutor().submit(consumer);
    }

    private EventConsumer getConsumer(String uuid) throws IllegalArgumentException {
        EventConsumer consumer = this.flowManager.getConsumer(uuid);
        if (consumer == null) {
            throw new IllegalArgumentException("Unable to get a consumer using uuid: " + uuid);
        }
        return consumer;
    }
}

