/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geobatch.services.rest.impl.utils;

import it.geosolutions.geobatch.catalog.Catalog;
import it.geosolutions.geobatch.configuration.event.action.ActionConfiguration;
import it.geosolutions.geobatch.configuration.event.consumer.EventConsumerConfiguration;
import it.geosolutions.geobatch.configuration.flow.file.FileBasedFlowConfiguration;
import it.geosolutions.geobatch.flow.event.consumer.EventConsumerStatus;
import it.geosolutions.geobatch.flow.file.FileBasedFlowManager;
import it.geosolutions.geobatch.services.rest.model.RESTActionShort;
import it.geosolutions.geobatch.services.rest.model.RESTConsumerStatus;
import it.geosolutions.geobatch.services.rest.model.RESTFlow;
import it.geosolutions.geobatch.services.rest.model.RESTFlowList;
import it.geosolutions.geobatch.services.rest.model.RESTFlowShort;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(RESTUtils.class);
    private static final Map<EventConsumerStatus, RESTConsumerStatus.Status> statusMapping;
    private static final Map<EventConsumerStatus, String> extStatusMapping;

    public static RESTConsumerStatus.Status convertStatus(EventConsumerStatus status) {
        RESTConsumerStatus.Status ret = statusMapping.get(status);
        if (ret == null) {
            LOGGER.error("Event is in status " + status + ". It should not happen.");
            ret = RESTConsumerStatus.Status.FAIL;
        }
        return ret;
    }

    public static String getExtStatus(EventConsumerStatus status) {
        return extStatusMapping.get(status);
    }

    public static String formatDate(Calendar time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy'-'MM'-'dd' 'HH':'mm':'ss'.'SSS");
        TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(TZ_UTC);
        return formatter.format(time.getTime());
    }

    public static List<FileBasedFlowManager> getFlowManagerList(Catalog catalog) {
        if (catalog == null) {
            throw new IllegalStateException("The catalog is null");
        }
        List fbfm = catalog.getFlowManagers(FileBasedFlowManager.class);
        if (fbfm == null) {
            throw new IllegalStateException("No flowManagers found");
        }
        return fbfm;
    }

    public static FileBasedFlowManager getFlowManager(Catalog catalog, String id) {
        if (catalog == null) {
            throw new IllegalStateException("The catalog is null");
        }
        FileBasedFlowManager ret = (FileBasedFlowManager)catalog.getFlowManager(id, FileBasedFlowManager.class);
        return ret;
    }

    public static RESTFlowList convertFlowList(List<FileBasedFlowManager> flowManagerList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Load needed data structures...");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Found " + flowManagerList.size() + " flow(s)");
        }
        RESTFlowList flowsList = new RESTFlowList();
        for (FileBasedFlowManager flowManager : flowManagerList) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Examining flow '" + flowManager.getId() + "'");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Flow " + flowManager.getId() + ": add current flow to shortFlowsList");
            }
            RESTFlowShort flow = new RESTFlowShort();
            flow.setId(flowManager.getId());
            flow.setName(flowManager.getName());
            flow.setDescription(flowManager.getDescription());
            flowsList.add(flow);
        }
        return flowsList;
    }

    public static RESTFlow convertFlow(FileBasedFlowManager flowManager) throws IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converting flow '" + flowManager.getId() + "'");
        }
        EventConsumerConfiguration ecc = null;
        if (flowManager.getConfiguration() == null || ((FileBasedFlowConfiguration)flowManager.getConfiguration()).getEventConsumerConfiguration() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Flow ").append(flowManager.getId()).append(" configuration is not a valid geobatch configuration");
            throw new IllegalStateException(sb.toString());
        }
        ecc = ((FileBasedFlowConfiguration)flowManager.getConfiguration()).getEventConsumerConfiguration();
        RESTFlow flow = new RESTFlow();
        flow.setId(flowManager.getId());
        flow.setName(flowManager.getName());
        flow.setDescription(flowManager.getDescription());
        for (ActionConfiguration action : ecc.getActions()) {
            RESTActionShort actionShort = new RESTActionShort();
            actionShort.setId(action.getId());
            actionShort.setName(action.getName());
            actionShort.setDescription(action.getDescription());
            flow.addAction(actionShort);
        }
        return flow;
    }

    static {
        EnumMap<EventConsumerStatus, Object> tmp = new EnumMap<EventConsumerStatus, Object>(EventConsumerStatus.class);
        tmp.put(EventConsumerStatus.CANCELED, (Object)RESTConsumerStatus.Status.FAIL);
        tmp.put(EventConsumerStatus.COMPLETED, (Object)RESTConsumerStatus.Status.SUCCESS);
        tmp.put(EventConsumerStatus.EXECUTING, (Object)RESTConsumerStatus.Status.RUNNING);
        tmp.put(EventConsumerStatus.FAILED, (Object)RESTConsumerStatus.Status.FAIL);
        tmp.put(EventConsumerStatus.IDLE, (Object)null);
        tmp.put(EventConsumerStatus.PAUSED, (Object)RESTConsumerStatus.Status.RUNNING);
        tmp.put(EventConsumerStatus.WAITING, (Object)null);
        statusMapping = Collections.unmodifiableMap(tmp);
        tmp = new EnumMap(EventConsumerStatus.class);
        tmp.put(EventConsumerStatus.CANCELED, (Object)EventConsumerStatus.CANCELED.name());
        tmp.put(EventConsumerStatus.COMPLETED, (Object)null);
        tmp.put(EventConsumerStatus.EXECUTING, (Object)null);
        tmp.put(EventConsumerStatus.FAILED, (Object)null);
        tmp.put(EventConsumerStatus.IDLE, (Object)EventConsumerStatus.IDLE.name());
        tmp.put(EventConsumerStatus.PAUSED, (Object)EventConsumerStatus.PAUSED.name());
        tmp.put(EventConsumerStatus.WAITING, (Object)EventConsumerStatus.WAITING.name());
        extStatusMapping = Collections.unmodifiableMap(tmp);
    }
}

