/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.enums.DataType;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class AttributeDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(AttributeDAOTest.class);

    @Test
    public void testPersistAttribute() throws Exception {
        Attribute loaded;
        long id;
        block5: {
            long resourceId;
            block4: {
                String TEXT1 = "text1";
                String TEXT2 = "text2";
                Category category = new Category();
                category.setName("MAP");
                categoryDAO.persist((Object[])new Category[]{category});
                AttributeDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
                AttributeDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
                Resource resource = new Resource();
                resource.setName("resource1");
                resource.setCreation(new Date());
                resource.setCategory(category);
                resourceDAO.persist((Object[])new Resource[]{resource});
                resourceId = resource.getId();
                AttributeDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
                AttributeDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
                StoredData data = new StoredData();
                data.setData("Dummy data");
                data.setResource(resource);
                data.setId(resourceId);
                storedDataDAO.persist((Object[])new StoredData[]{data});
                AttributeDAOTest.assertEquals((int)1, (int)storedDataDAO.count(null));
                AttributeDAOTest.assertEquals((int)1, (int)storedDataDAO.findAll().size());
                Attribute attribute = new Attribute();
                attribute.setName("attr1");
                attribute.setTextValue("text1");
                attribute.setNumberValue(Double.valueOf(1.0));
                attribute.setDateValue(new Date());
                attribute.setResource(resource);
                try {
                    attributeDAO.persist((Object[])new Attribute[]{attribute});
                    AttributeDAOTest.fail((String)"Exception not trapped");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.debug("OK: exception trapped", (Throwable)exc);
                }
            }
            Resource resource = (Resource)resourceDAO.find(Long.valueOf(resourceId));
            Attribute attribute = new Attribute();
            attribute.setName("attr1");
            attribute.setTextValue("text1");
            attribute.setResource(resource);
            attributeDAO.persist((Object[])new Attribute[]{attribute});
            id = attribute.getId();
            Attribute loaded2 = (Attribute)attributeDAO.find(Long.valueOf(id));
            AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute", (Object)loaded2);
            resource = (Resource)resourceDAO.find(Long.valueOf(resourceId));
            List attributes = resource.getAttribute();
            AttributeDAOTest.assertNotNull((String)"Can't retrieve Attributes list from Resource", (Object)attributes);
            AttributeDAOTest.assertEquals((int)1, (int)attributes.size());
            loaded = (Attribute)attributeDAO.find(Long.valueOf(id));
            AttributeDAOTest.assertEquals((String)"text1", (String)loaded.getTextValue());
            loaded.setTextValue("text2");
            loaded.setNumberValue(Double.valueOf(2.0));
            loaded.setDateValue(new Date());
            try {
                attributeDAO.merge((Object)loaded);
                AttributeDAOTest.fail((String)"Exception not trapped");
            }
            catch (Exception exc) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("OK: exception trapped", (Throwable)exc);
            }
        }
        loaded = (Attribute)attributeDAO.find(Long.valueOf(id));
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute", (Object)loaded);
        AttributeDAOTest.assertEquals((String)"text1", (String)loaded.getTextValue());
        loaded.setTextValue("text2");
        attributeDAO.merge((Object)loaded);
        loaded = (Attribute)attributeDAO.find(Long.valueOf(id));
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute", (Object)loaded);
        AttributeDAOTest.assertEquals((String)"text2", (String)loaded.getTextValue());
        AttributeDAOTest.assertEquals((int)1, (int)attributeDAO.count(null));
        AttributeDAOTest.assertEquals((int)1, (int)attributeDAO.findAll().size());
        attributeDAO.removeById(Long.valueOf(id));
        AttributeDAOTest.assertNull((String)"Attribute not deleted", (Object)attributeDAO.find(Long.valueOf(id)));
    }

    @Test
    public void testSearchAttribute() throws Exception {
        int i;
        Attribute attribute;
        int i2;
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        AttributeDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        AttributeDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("resource1");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        AttributeDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        AttributeDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        StoredData data = new StoredData();
        data.setData("Dummy data");
        data.setResource(resource);
        data.setId(resource.getId().longValue());
        storedDataDAO.persist((Object[])new StoredData[]{data});
        AttributeDAOTest.assertEquals((int)1, (int)storedDataDAO.count(null));
        AttributeDAOTest.assertEquals((int)1, (int)storedDataDAO.findAll().size());
        for (i2 = 0; i2 < 10; ++i2) {
            attribute = new Attribute();
            attribute.setName("attrnumber" + i2);
            attribute.setNumberValue(Double.valueOf(Integer.valueOf(i2).doubleValue()));
            attribute.setResource(resource);
            attributeDAO.persist((Object[])new Attribute[]{attribute});
        }
        for (i2 = 11; i2 < 21; ++i2) {
            attribute = new Attribute();
            attribute.setName("attrtext" + i2);
            attribute.setTextValue("textValue" + i2);
            attribute.setResource(resource);
            attributeDAO.persist((Object[])new Attribute[]{attribute});
        }
        for (i2 = 21; i2 < 31; ++i2) {
            attribute = new Attribute();
            attribute.setName("attrdate" + i2);
            attribute.setDateValue(new Date());
            attribute.setResource(resource);
            attributeDAO.persist((Object[])new Attribute[]{attribute});
        }
        Search criteria = new Search(Attribute.class);
        criteria.addFilterEqual("type", (Object)DataType.DATE);
        List attrList = attributeDAO.search((ISearch)criteria);
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute list", (Object)attrList);
        AttributeDAOTest.assertEquals((int)10, (int)attrList.size());
        criteria = new Search(Attribute.class);
        criteria.addFilterNotEqual("type", (Object)DataType.DATE);
        attrList = attributeDAO.search((ISearch)criteria);
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute list", (Object)attrList);
        AttributeDAOTest.assertEquals((int)20, (int)attrList.size());
        criteria = new Search(Attribute.class);
        criteria.addFilterEqual("type", (Object)DataType.NUMBER);
        criteria.addFilterGreaterThan("numberValue", (Object)2.0);
        criteria.addFilterLessThan("numberValue", (Object)8.0);
        criteria.addFilterILike("name", "%number%");
        attrList = attributeDAO.search((ISearch)criteria);
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute list", (Object)attrList);
        AttributeDAOTest.assertEquals((int)5, (int)attrList.size());
        for (i = 0; i < attrList.size(); ++i) {
            if (!((Attribute)attrList.get(i)).getName().contains("attrnumber")) {
                AttributeDAOTest.fail((String)"Attribute name not matched!");
            }
            AttributeDAOTest.assertEquals((Object)DataType.NUMBER, (Object)((Attribute)attrList.get(i)).getType());
        }
        criteria = new Search(Attribute.class);
        criteria.addFilterEqual("type", (Object)DataType.DATE);
        criteria.addFilterLessThan("dateValue", (Object)new Date());
        criteria.addFilterILike("name", "%date%");
        attrList = attributeDAO.search((ISearch)criteria);
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute list", (Object)attrList);
        AttributeDAOTest.assertEquals((int)10, (int)attrList.size());
        for (i = 0; i < attrList.size(); ++i) {
            if (!((Attribute)attrList.get(i)).getName().contains("attrdate")) {
                AttributeDAOTest.fail((String)"Attribute name not matched!");
            }
            AttributeDAOTest.assertEquals((Object)DataType.DATE, (Object)((Attribute)attrList.get(i)).getType());
        }
        criteria = new Search(Attribute.class);
        criteria.addFilterOr(new Filter[]{Filter.notEqual((String)"type", (Object)DataType.NUMBER), Filter.equal((String)"type", (Object)DataType.DATE)});
        attrList = attributeDAO.search((ISearch)criteria);
        AttributeDAOTest.assertNotNull((String)"Can't retrieve Attribute list", (Object)attrList);
        AttributeDAOTest.assertEquals((int)20, (int)attrList.size());
        for (i = 0; i < attrList.size(); ++i) {
            if (!((Attribute)attrList.get(i)).getType().equals((Object)DataType.NUMBER)) continue;
            AttributeDAOTest.fail((String)"Attribute type not matched!");
        }
        resourceDAO.removeById(resource.getId());
        AttributeDAOTest.assertNull((String)"Resource not deleted", (Object)resourceDAO.find(resource.getId()));
        AttributeDAOTest.assertEquals((int)0, (int)attributeDAO.count(null));
        AttributeDAOTest.assertEquals((int)0, (int)storedDataDAO.count(null));
    }
}

