/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.ldap.impl.LdapBaseDAOImpl;
import it.geosolutions.geostore.core.dao.ldap.impl.UserGroupDAOImpl;
import it.geosolutions.geostore.core.dao.search.GeoStoreISearchWrapper;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.support.AbstractContextMapper;

public class UserDAOImpl
extends LdapBaseDAOImpl
implements UserDAO {
    protected Map<String, String> attributesMapper = new HashMap<String, String>();
    private Pattern memberPattern = Pattern.compile("^(.*)$");
    private String adminRoleGroup = "ADMIN";
    UserGroupDAOImpl userGroupDAO = null;

    public UserDAOImpl(ContextSource contextSource) {
        super(contextSource);
    }

    public void setUserGroupDAO(UserGroupDAOImpl userGroupDAO) {
        if (this.userGroupDAO == null) {
            this.userGroupDAO = userGroupDAO;
            userGroupDAO.setUserDAO(this);
        }
    }

    public String getAdminRoleGroup() {
        return this.adminRoleGroup;
    }

    public void setAdminRoleGroup(String adminRoleGroup) {
        this.adminRoleGroup = adminRoleGroup;
    }

    public void setMemberPattern(String memberPattern) {
        this.memberPattern = Pattern.compile(memberPattern);
    }

    public Map<String, String> getAttributesMapper() {
        return this.attributesMapper;
    }

    public void setAttributesMapper(Map<String, String> attributesMapper) {
        this.attributesMapper = attributesMapper;
    }

    public void persist(User ... entities) {
    }

    @Override
    public List<User> findAll() {
        return this.ldapSearch(this.baseFilter, new LdapBaseDAOImpl.NullDirContextProcessor());
    }

    @Override
    public List<User> search(ISearch search) {
        if (this.isNested(search)) {
            ArrayList<User> users = new ArrayList<User>();
            for (UserGroup group : this.userGroupDAO.search(this.getNestedSearch(search))) {
                users.addAll(group.getUsers());
            }
            return users;
        }
        return this.ldapSearch(this.combineFilters(this.baseFilter, this.getLdapFilter(search, this.getPropertyMapper())), this.getProcessorForSearch(search));
    }

    private Map<String, Object> getPropertyMapper() {
        HashMap<String, Object> mapper = new HashMap<String, Object>();
        mapper.put("name", this.nameAttribute);
        for (String ldap : this.attributesMapper.keySet()) {
            mapper.put(this.attributesMapper.get(ldap), ldap);
        }
        if (this.userGroupDAO != null) {
            mapper.put("groups", this.userGroupDAO.getPropertyMapper());
        }
        return mapper;
    }

    protected List<User> ldapSearch(String filter, DirContextProcessor processor) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        return this.template.search(this.searchBase, filter, controls, (ContextMapper)new AbstractContextMapper(){
            int counter = 1;

            protected User doMapFromContext(DirContextOperations ctx) {
                User user = new User();
                user.setId(Long.valueOf(this.counter++));
                user.setEnabled(true);
                user.setName(ctx.getStringAttribute(UserDAOImpl.this.nameAttribute));
                user.setAttribute(UserDAOImpl.this.fetchAttributes(ctx));
                UserDAOImpl.this.assignGroupsAndRole(ctx, user);
                return user;
            }
        }, processor);
    }

    private List<UserAttribute> fetchAttributes(DirContextOperations ctx) {
        ArrayList<UserAttribute> attributes = new ArrayList<UserAttribute>();
        for (String ldapAttr : this.attributesMapper.keySet()) {
            String value = ctx.getStringAttribute(ldapAttr);
            String userAttr = this.attributesMapper.get(ldapAttr);
            UserAttribute attr = new UserAttribute();
            attr.setName(userAttr);
            attr.setValue(value);
            attributes.add(attr);
        }
        return attributes;
    }

    private void assignGroupsAndRole(DirContextOperations ctx, User user) {
        user.setGroups(new HashSet());
        user.setRole(Role.USER);
        if (this.userGroupDAO != null) {
            Search searchCriteria = new Search(UserGroup.class);
            searchCriteria.addFilterSome("user", new Filter("name", (Object)ctx.getNameInNamespace(), 0));
            GeoStoreISearchWrapper searchWrapper = new GeoStoreISearchWrapper((ISearch)searchCriteria, this.getClass());
            for (UserGroup ug : this.userGroupDAO.search(searchWrapper)) {
                if (this.isAdminGroup(ug)) {
                    user.setRole(Role.ADMIN);
                }
                user.getGroups().add(ug);
            }
        }
    }

    private boolean isAdminGroup(UserGroup ug) {
        return ug.getGroupName().equalsIgnoreCase(this.adminRoleGroup);
    }

    @Override
    public User merge(User entity) {
        return entity;
    }

    @Override
    public boolean remove(User entity) {
        return true;
    }

    @Override
    public boolean removeById(Long id) {
        return true;
    }

    @Override
    public User find(Long id) {
        return null;
    }

    public User[] save(User ... entities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int count(ISearch search) {
        return this.search(search).size();
    }

    public User createMemberUser(String member) {
        User user = new User();
        user.setEnabled(true);
        user.setId(Long.valueOf(-1L));
        user.setName(this.getMemberName(member));
        return user;
    }

    private String getMemberName(String member) {
        Matcher m = this.memberPattern.matcher(member);
        if (m.find()) {
            return m.group(1);
        }
        return member;
    }
}

