/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.dao.ldap.impl.LdapBaseDAOImpl;
import it.geosolutions.geostore.core.dao.ldap.impl.UserDAOImpl;
import it.geosolutions.geostore.core.dao.search.GeoStoreISearchWrapper;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.springframework.expression.Expression;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.support.AbstractContextMapper;

public class UserGroupDAOImpl
extends LdapBaseDAOImpl
implements UserGroupDAO {
    private boolean addEveryOneGroup = false;
    private String memberAttribute = "member";
    private UserDAOImpl userDAO = null;

    public UserGroupDAOImpl(ContextSource contextSource) {
        super(contextSource);
    }

    public String getMemberAttribute() {
        return this.memberAttribute;
    }

    public void setMemberAttribute(String memberAttribute) {
        this.memberAttribute = memberAttribute;
    }

    public void setUserDAO(UserDAOImpl userDAO) {
        if (this.userDAO == null) {
            this.userDAO = userDAO;
            userDAO.setUserGroupDAO(this);
        }
    }

    public boolean isAddEveryOneGroup() {
        return this.addEveryOneGroup;
    }

    public void setAddEveryOneGroup(boolean addEveryOneGroup) {
        this.addEveryOneGroup = addEveryOneGroup;
    }

    public void persist(UserGroup ... entities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<UserGroup> findAll() {
        return this.addEveryOne(this.ldapSearch(this.baseFilter, new LdapBaseDAOImpl.NullDirContextProcessor(), null), null);
    }

    @Override
    public UserGroup find(Long id) {
        return null;
    }

    @Override
    public UserGroup findByName(String name) {
        Search searchCriteria = new Search(UserGroup.class);
        searchCriteria.addFilterEqual(this.nameAttribute, (Object)name);
        UserGroup result = null;
        List<UserGroup> existingGroups = this.search((ISearch)searchCriteria);
        if (existingGroups.size() > 0) {
            result = existingGroups.get(0);
        }
        return result;
    }

    @Override
    public List<UserGroup> search(ISearch search) {
        Object filter;
        if (this.isNested(search)) {
            Filter nested = this.getNestedFilter((Filter)search.getFilters().get(0));
            filter = this.memberAttribute + "=" + nested.getValue().toString();
        } else {
            filter = this.getLdapFilter(search, this.getPropertyMapper());
        }
        return this.addEveryOne(this.ldapSearch(this.combineFilters(this.baseFilter, (String)filter), this.getProcessorForSearch(search), search), search);
    }

    public Map<String, Object> getPropertyMapper() {
        HashMap<String, Object> mapper = new HashMap<String, Object>();
        mapper.put("groupName", this.nameAttribute);
        mapper.put("description", this.descriptionAttribute);
        return mapper;
    }

    protected List<UserGroup> ldapSearch(String filter, DirContextProcessor processor, final ISearch search) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        return this.template.search(this.searchBase, filter, controls, (ContextMapper)new AbstractContextMapper(){
            int counter = 1;

            protected UserGroup doMapFromContext(DirContextOperations ctx) {
                String[] memberAttrs;
                UserGroup group = new UserGroup();
                group.setId(Long.valueOf(this.counter++));
                group.setEnabled(true);
                group.setGroupName(ctx.getStringAttribute(UserGroupDAOImpl.this.nameAttribute));
                group.setDescription(ctx.getStringAttribute(UserGroupDAOImpl.this.descriptionAttribute));
                if (!"".equals(UserGroupDAOImpl.this.memberAttribute) && UserGroupDAOImpl.this.userDAO != null && UserGroupDAOImpl.this.loadUsers(search) && (memberAttrs = ctx.getStringAttributes(UserGroupDAOImpl.this.memberAttribute)) != null && memberAttrs.length > 0) {
                    for (String member : memberAttrs) {
                        group.getUsers().add(UserGroupDAOImpl.this.userDAO.createMemberUser(member));
                    }
                }
                return group;
            }
        }, processor);
    }

    private List<UserGroup> addEveryOne(List<UserGroup> groups, ISearch search) {
        UserGroup everyoneGroup = new UserGroup();
        everyoneGroup.setGroupName(GroupReservedNames.EVERYONE.groupName());
        everyoneGroup.setId(Long.valueOf(groups.size() + 1));
        everyoneGroup.setEnabled(true);
        if (search == null || this.matchFilters(everyoneGroup, search)) {
            boolean everyoneFound = false;
            for (UserGroup group : groups) {
                if (!group.getGroupName().equals(everyoneGroup.getGroupName())) continue;
                everyoneFound = true;
            }
            if (!everyoneFound && this.addEveryOneGroup) {
                groups.add(everyoneGroup);
            }
        }
        return groups;
    }

    protected boolean matchFilters(UserGroup group, ISearch search) {
        Expression matchExpression = this.getSearchExpression(search);
        return (Boolean)matchExpression.getValue((Object)group, Boolean.class);
    }

    @Override
    public UserGroup merge(UserGroup entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(UserGroup entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeById(Long id) {
        throw new UnsupportedOperationException();
    }

    public UserGroup[] save(UserGroup ... entities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int count(ISearch search) {
        return this.search(search).size();
    }

    protected boolean loadUsers(ISearch search) {
        GeoStoreISearchWrapper wrapper;
        Class<?> clazz;
        return !(search instanceof GeoStoreISearchWrapper) || (clazz = (wrapper = (GeoStoreISearchWrapper)search).getCallerContext()) == null || !UserDAO.class.isAssignableFrom(clazz);
    }
}

