/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ldap.BaseDAOTest;
import it.geosolutions.geostore.core.dao.ldap.impl.UserGroupDAOImpl;
import it.geosolutions.geostore.core.ldap.MockContextSource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;

public class UserGroupDAOTest
extends BaseDAOTest {
    @Test
    public void testFindAll() {
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        List groups = userGroupDAO.findAll();
        Assert.assertEquals((long)2L, (long)groups.size());
        UserGroup group = (UserGroup)groups.get(0);
        Assert.assertEquals((Object)"group", (Object)group.getGroupName());
    }

    @Test
    public void testSearchByname() {
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        Search search = new Search(User.class);
        List groups = userGroupDAO.search((ISearch)search.addFilter(Filter.equal((String)"groupName", (Object)"group")));
        Assert.assertEquals((long)1L, (long)groups.size());
        UserGroup group = (UserGroup)groups.get(0);
        Assert.assertEquals((Object)"group", (Object)group.getGroupName());
    }

    @Test
    public void testAddEveryOne() {
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        userGroupDAO.setAddEveryOneGroup(true);
        List groups = userGroupDAO.findAll();
        Assert.assertEquals((long)3L, (long)groups.size());
        UserGroup group = (UserGroup)groups.get(2);
        Assert.assertEquals((Object)"everyone", (Object)group.getGroupName());
    }
}

