/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.Date;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class UserDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(UserDAOTest.class);

    @Test
    public void testPersistUser() throws Exception {
        String NAME = "NAME";
        String VALUE = "value";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting User");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        UserDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        UserDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        UserDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        UserDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        UserGroup g1 = new UserGroup();
        g1.setGroupName("GROUP1");
        UserGroup g2 = new UserGroup();
        g2.setGroupName("GROUP2");
        groups.add(g1);
        groups.add(g2);
        userGroupDAO.persist((Object[])new UserGroup[]{g1});
        userGroupDAO.persist((Object[])new UserGroup[]{g2});
        UserDAOTest.assertEquals((int)2, (int)userGroupDAO.count(null));
        UserDAOTest.assertEquals((int)2, (int)userGroupDAO.findAll().size());
        User user = new User();
        user.setGroups(groups);
        user.setName("USER_NAME");
        user.setNewPassword("user");
        user.setRole(Role.ADMIN);
        userDAO.persist((Object[])new User[]{user});
        long userId = user.getId();
        UserDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        UserDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserAttribute attribute = new UserAttribute();
        attribute.setName("attr1");
        attribute.setValue("value");
        attribute.setUser(user);
        userAttributeDAO.persist((Object[])new UserAttribute[]{attribute});
        long attributeId = attribute.getId();
        UserDAOTest.assertEquals((int)1, (int)userAttributeDAO.count(null));
        UserDAOTest.assertEquals((int)1, (int)userAttributeDAO.findAll().size());
        SecurityRule security1 = new SecurityRule();
        security1.setCanRead(true);
        security1.setCanWrite(true);
        security1.setResource(resource);
        security1.setGroup(g1);
        security1.setUser(user);
        securityDAO.persist((Object[])new SecurityRule[]{security1});
        long securityId1 = security1.getId();
        UserDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        UserDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        SecurityRule security2 = new SecurityRule();
        security2.setCanRead(true);
        security2.setCanWrite(true);
        security2.setResource(resource);
        security2.setGroup(g2);
        securityDAO.persist((Object[])new SecurityRule[]{security2});
        long securityId2 = security2.getId();
        UserDAOTest.assertEquals((int)2, (int)securityDAO.count(null));
        UserDAOTest.assertEquals((int)2, (int)securityDAO.findAll().size());
        User loaded = (User)userDAO.find(Long.valueOf(userId));
        UserDAOTest.assertNotNull((String)"Can't retrieve User", (Object)loaded);
        userDAO.removeById(Long.valueOf(userId));
        UserDAOTest.assertNull((String)"User not deleted", (Object)userDAO.find(Long.valueOf(userId)));
        UserDAOTest.assertNull((String)"SecurityRule not deleted", (Object)securityDAO.find(Long.valueOf(securityId1)));
        UserDAOTest.assertNotNull((String)"Group SecurityRule deleted while deleting user...", (Object)securityDAO.find(Long.valueOf(securityId2)));
        UserDAOTest.assertNull((String)"UserAttribute not deleted", (Object)userAttributeDAO.find(Long.valueOf(attributeId)));
    }
}

