/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class SecurityDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(SecurityDAOTest.class);

    @Test
    public void testPersistSecurity() throws Exception {
        String NAME = "NAME";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Security");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        long categoryId = category.getId();
        SecurityDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        SecurityDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        Resource loaded = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityDAOTest.assertNotNull((Object)loaded);
        SecurityDAOTest.assertNull((Object)loaded.getCreator());
        SecurityDAOTest.assertNull((Object)loaded.getEditor());
        Resource loaded2 = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource(loaded2);
        securityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId = security.getId();
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        loaded2 = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityDAOTest.assertNull((Object)loaded2.getCreator());
        SecurityDAOTest.assertNull((Object)loaded2.getEditor());
        loaded2 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded2);
        SecurityDAOTest.assertTrue((boolean)loaded2.isCanWrite());
        loaded2.setCanWrite(false);
        securityDAO.merge((Object)loaded2);
        loaded2 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded2);
        SecurityDAOTest.assertFalse((boolean)loaded2.isCanWrite());
        securityDAO.removeById(Long.valueOf(securityId));
        SecurityDAOTest.assertNull((String)"Security not deleted", (Object)securityDAO.find(Long.valueOf(categoryId)));
    }

    @Test
    public void testPersistSecurityUsingNames() throws Exception {
        String NAME = "NAME";
        String USERNAME = "USER";
        String GROUPNAME = "GROUP";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Security");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        long categoryId = category.getId();
        SecurityDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        User user = new User();
        user.setName("USER");
        user.setRole(Role.USER);
        userDAO.persist((Object[])new User[]{user});
        long userId = user.getId();
        SecurityDAOTest.assertEquals((int)1, (int)userDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)userDAO.findAll().size());
        UserGroup group = new UserGroup();
        group.setGroupName("GROUP");
        userGroupDAO.persist((Object[])new UserGroup[]{group});
        long groupId = group.getId();
        SecurityDAOTest.assertEquals((int)1, (int)userGroupDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)userGroupDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        SecurityDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        Resource loaded = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityDAOTest.assertNull((Object)loaded.getCreator());
        SecurityDAOTest.assertNull((Object)loaded.getEditor());
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        security.setUsername("testuser");
        securityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId = security.getId();
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        SecurityRule rule = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((Object)rule);
        SecurityDAOTest.assertNotNull((Object)rule.getUsername());
        Resource loaded2 = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityDAOTest.assertNotNull((Object)loaded2.getCreator());
        SecurityDAOTest.assertNotNull((Object)loaded2.getEditor());
        SecurityDAOTest.assertEquals((String)"testuser", (String)loaded2.getCreator());
        SecurityDAOTest.assertEquals((String)"testuser", (String)loaded2.getEditor());
        securityDAO.removeById(Long.valueOf(securityId));
        Resource loaded3 = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        loaded3.setEditor(null);
        resourceDAO.merge((Object)loaded3);
        SecurityRule security2 = new SecurityRule();
        security2.setCanRead(true);
        security2.setCanWrite(true);
        security2.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        User testUser = new User();
        testUser.setName("TheTestUser");
        testUser.setId(Long.valueOf(userId));
        security2.setUser(testUser);
        securityDAO.persist((Object[])new SecurityRule[]{security2});
        securityId = security2.getId();
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        SecurityRule rule2 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((Object)rule2);
        SecurityDAOTest.assertNotNull((Object)rule2.getUser());
        loaded3 = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        SecurityDAOTest.assertNotNull((Object)loaded3.getCreator());
        SecurityDAOTest.assertNotNull((Object)loaded3.getEditor());
        SecurityDAOTest.assertEquals((String)"testuser", (String)loaded3.getCreator());
        SecurityDAOTest.assertEquals((String)testUser.getName(), (String)loaded3.getEditor());
        securityDAO.removeById(Long.valueOf(securityId));
        security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        security.setGroupname("testgroup");
        securityDAO.persist((Object[])new SecurityRule[]{security});
        securityId = security.getId();
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        rule = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((Object)rule);
        SecurityDAOTest.assertNotNull((Object)rule.getGroupname());
        securityDAO.removeById(Long.valueOf(securityId));
        security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource((Resource)resourceDAO.find(Long.valueOf(resourceId)));
        UserGroup testGroup = new UserGroup();
        testGroup.setId(Long.valueOf(groupId));
        security.setGroup(testGroup);
        securityDAO.persist((Object[])new SecurityRule[]{security});
        securityId = security.getId();
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        SecurityDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        SecurityRule rule3 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((Object)rule3);
        SecurityDAOTest.assertNotNull((Object)rule3.getGroup());
        loaded3 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded3);
        SecurityDAOTest.assertTrue((boolean)loaded3.isCanWrite());
        loaded3.setCanWrite(false);
        securityDAO.merge((Object)loaded3);
        loaded3 = (SecurityRule)securityDAO.find(Long.valueOf(securityId));
        SecurityDAOTest.assertNotNull((String)"Can't retrieve Security", (Object)loaded3);
        SecurityDAOTest.assertFalse((boolean)loaded3.isCanWrite());
        securityDAO.removeById(Long.valueOf(securityId));
        SecurityDAOTest.assertNull((String)"Security not deleted", (Object)securityDAO.find(Long.valueOf(categoryId)));
    }
}

