/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import java.util.Date;
import org.junit.Test;

public class ResourceDAOTest
extends BaseDAOTest {
    @Test
    public void testPersistResource() throws Exception {
        String NAME1 = "FIRST_NAME";
        String NAME2 = "SECOND_NAME";
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        ResourceDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        ResourceDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("FIRST_NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resource.setCreator("USER1");
        resource.setEditor("USER2");
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        ResourceDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        ResourceDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        StoredData data = new StoredData();
        data.setData("Dummy data");
        data.setResource(resource);
        data.setId(resource.getId().longValue());
        storedDataDAO.persist((Object[])new StoredData[]{data});
        long dataId = data.getId();
        ResourceDAOTest.assertEquals((int)1, (int)storedDataDAO.count(null));
        ResourceDAOTest.assertEquals((int)1, (int)storedDataDAO.findAll().size());
        ResourceDAOTest.assertEquals((long)dataId, (long)resourceId);
        SecurityRule security = new SecurityRule();
        security.setCanRead(true);
        security.setCanWrite(true);
        security.setResource(resource);
        securityDAO.persist((Object[])new SecurityRule[]{security});
        long securityId = security.getId();
        ResourceDAOTest.assertEquals((int)1, (int)securityDAO.count(null));
        ResourceDAOTest.assertEquals((int)1, (int)securityDAO.findAll().size());
        Resource loaded = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        ResourceDAOTest.assertNotNull((String)"Can't retrieve resource", (Object)loaded);
        ResourceDAOTest.assertEquals((String)"FIRST_NAME", (String)loaded.getName());
        ResourceDAOTest.assertEquals((String)"USER1", (String)loaded.getCreator());
        ResourceDAOTest.assertEquals((String)"USER2", (String)loaded.getEditor());
        loaded.setName("SECOND_NAME");
        loaded.setCreator("USER1Updated");
        loaded.setEditor("USER2Updated");
        resourceDAO.merge((Object)loaded);
        loaded = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        ResourceDAOTest.assertNotNull((String)"Can't retrieve resource", (Object)loaded);
        ResourceDAOTest.assertEquals((String)"SECOND_NAME", (String)loaded.getName());
        ResourceDAOTest.assertEquals((String)"USER1Updated", (String)loaded.getCreator());
        ResourceDAOTest.assertEquals((String)"USER2Updated", (String)loaded.getEditor());
        loaded = (Resource)resourceDAO.find(Long.valueOf(resourceId));
        StoredData data2 = loaded.getData();
        ResourceDAOTest.assertNotNull((String)"Can't retrieve StoredData from Resource", (Object)data2);
        resourceDAO.removeById(Long.valueOf(resourceId));
        ResourceDAOTest.assertNull((String)"Resource not deleted", (Object)resourceDAO.find(Long.valueOf(resourceId)));
        ResourceDAOTest.assertNull((String)"SecurityRule not deleted", (Object)securityDAO.find(Long.valueOf(securityId)));
        ResourceDAOTest.assertNull((String)"StoredData not deleted", (Object)storedDataDAO.find(Long.valueOf(dataId)));
    }
}

