/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.dao.impl.BaseDAO;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="geostoreTransactionManager")
public class SecurityDAOImpl
extends BaseDAO<SecurityRule, Long>
implements SecurityDAO {
    private static final Logger LOGGER = LogManager.getLogger(SecurityDAOImpl.class);
    private UserGroupDAO userGroupDAO;
    private ResourceDAO resourceDAO;

    public void persist(SecurityRule ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for Security ... ");
        }
        for (SecurityRule rule : entities) {
            this.validateGroup(rule);
            this.updateResourceCreatorIfEmpty(rule);
        }
        super.persist((Object[])entities);
    }

    protected void validateGroup(SecurityRule rule) throws InternalError {
        if (rule.getGroup() != null) {
            UserGroup ug = (UserGroup)this.userGroupDAO.find(rule.getGroup().getId());
            if (ug == null) {
                throw new InternalError("The usergroup having the provided Id doesn't exist");
            }
            rule.setGroup(ug);
        }
    }

    private void updateResourceCreatorIfEmpty(SecurityRule rule) {
        if (rule.getResource() != null && (rule.getUser() != null || rule.getUsername() != null)) {
            Resource resource = rule.getResource();
            boolean updated = false;
            if (resource.getCreator() == null) {
                resource.setCreator(rule.getUser() != null ? rule.getUser().getName() : rule.getUsername());
                updated = true;
            }
            if (updated) {
                this.resourceDAO.merge(resource);
            }
        }
    }

    @Override
    public List<SecurityRule> findAll() {
        return super.findAll();
    }

    @Override
    public List<SecurityRule> search(ISearch search) {
        return super.search(search);
    }

    @Override
    public SecurityRule merge(SecurityRule entity) {
        return (SecurityRule)super.merge((Object)entity);
    }

    @Override
    public boolean remove(SecurityRule entity) {
        return super.remove((Object)entity);
    }

    @Override
    public boolean removeById(Long id) {
        return super.removeById((Serializable)id);
    }

    @Override
    public void addReadSecurityConstraints(Search searchCriteria, User user) {
        if (user.getRole() == Role.ADMIN) {
            return;
        }
        Filter userFiltering = Filter.or((Filter[])new Filter[]{Filter.equal((String)"username", (Object)user.getName()), Filter.equal((String)"user.name", (Object)user.getName())});
        if (user.getGroups() != null && !user.getGroups().isEmpty()) {
            ArrayList<Long> groupsId = new ArrayList<Long>();
            for (UserGroup group : user.getGroups()) {
                groupsId.add(group.getId());
            }
            userFiltering = Filter.or((Filter[])new Filter[]{userFiltering, Filter.in((String)"group.id", groupsId)});
        }
        Filter securityFilter = Filter.some((String)"security", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"canRead", (Object)true), userFiltering}));
        searchCriteria.addFilter(securityFilter);
    }

    @Override
    public void addAdvertisedSecurityConstraints(Search searchCriteria, User user) {
        if (user.getRole() == Role.ADMIN) {
            return;
        }
        Filter userFiltering = Filter.or((Filter[])new Filter[]{Filter.equal((String)"username", (Object)user.getName()), Filter.equal((String)"user.name", (Object)user.getName())});
        Filter advertisedFiltering = Filter.or((Filter[])new Filter[]{Filter.equal((String)"username", (Object)user.getName()), Filter.equal((String)"user.name", (Object)user.getName()), Filter.equal((String)"resource.advertised", (Object)true)});
        if (user.getGroups() != null && !user.getGroups().isEmpty()) {
            ArrayList<Long> groupsId = new ArrayList<Long>();
            for (UserGroup group : user.getGroups()) {
                groupsId.add(group.getId());
            }
            userFiltering = Filter.and((Filter[])new Filter[]{advertisedFiltering, Filter.or((Filter[])new Filter[]{userFiltering, Filter.in((String)"group.id", groupsId)})});
        }
        Filter securityFilter = Filter.some((String)"security", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"canRead", (Object)true), userFiltering}));
        searchCriteria.addFilter(securityFilter);
    }

    @Override
    public List<SecurityRule> findUserSecurityRule(String userName, long resourceId) {
        Search searchCriteria = new Search(SecurityRule.class);
        Filter securityFilter = Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equal((String)"resource.id", (Object)resourceId), Filter.equal((String)"username", (Object)userName)}), Filter.and((Filter[])new Filter[]{Filter.equal((String)"resource.id", (Object)resourceId), Filter.equal((String)"user.name", (Object)userName)})});
        searchCriteria.addFilter(securityFilter);
        return super.search((ISearch)searchCriteria);
    }

    @Override
    public List<SecurityRule> findResourceSecurityRules(long resourceId) {
        Search searchCriteria = new Search(SecurityRule.class);
        Filter securityFilter = Filter.equal((String)"resource.id", (Object)resourceId);
        searchCriteria.addFilter(securityFilter);
        searchCriteria.addFetch("ipRanges");
        searchCriteria.setDistinct(true);
        return super.search((ISearch)searchCriteria);
    }

    @Override
    public List<SecurityRule> findGroupSecurityRule(List<String> groupNames, long resourceId) {
        List<SecurityRule> rules = this.findResourceSecurityRules(resourceId);
        ArrayList<SecurityRule> filteredRules = new ArrayList<SecurityRule>();
        for (SecurityRule sr : rules) {
            if (sr.getGroup() == null || !groupNames.contains(sr.getGroup().getGroupName())) continue;
            filteredRules.add(sr);
        }
        return filteredRules;
    }

    public UserGroupDAO getUserGroupDAO() {
        return this.userGroupDAO;
    }

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public ResourceDAO getResourceDAO() {
        return this.resourceDAO;
    }

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }
}

