
    create table gs_attribute (
        id bigint generated by default as identity,
        attribute_date timestamp,
        name varchar(255) not null,
        attribute_number double,
        attribute_text varchar(255),
        attribute_type varchar(255) not null,
        resource_id bigint not null,
        primary key (id),
        unique (name, resource_id)
    );

    create table gs_category (
        id bigint generated by default as identity,
        name varchar(255) not null,
        primary key (id),
        unique (name)
    );

    create table gs_ip_range (
        id bigint generated by default as identity,
        cidr varchar(50) not null unique,
        description varchar(255),
        ip_high numeric,
        ip_low numeric,
        primary key (id)
    );

    create table gs_resource (
        id bigint generated by default as identity,
        advertised bool default true,
        creation timestamp not null,
        creator varchar(255),
        description varchar(10000),
        editor varchar(255),
        lastUpdate timestamp,
        metadata varchar(30000),
        name varchar(255) not null,
        category_id bigint not null,
        primary key (id),
        unique (name)
    );

    create table gs_resource_tags (
        tag_id bigint not null,
        resource_id bigint not null,
        primary key (tag_id, resource_id)
    );

    create table gs_security (
        id bigint generated by default as identity,
        canRead bit not null,
        canWrite bit not null,
        groupname varchar(255),
        username varchar(255),
        group_id bigint,
        resource_id bigint,
        user_id bigint,
        primary key (id),
        unique (resource_id, group_id),
        unique (user_id, resource_id)
    );

    create table gs_security_ip_range (
        security_id bigint not null,
        ip_range_id bigint not null,
        primary key (security_id, ip_range_id),
        unique (security_id, ip_range_id)
    );

    create table gs_stored_data (
        id bigint not null,
        stored_data varchar(10000000) not null,
        resource_id bigint not null,
        primary key (id),
        unique (resource_id)
    );

    create table gs_tag (
        id bigint generated by default as identity,
        color varchar(255) not null,
        description varchar(255),
        name varchar(255) not null unique,
        primary key (id)
    );

    create table gs_user (
        id bigint generated by default as identity,
        enabled char(255) not null,
        name varchar(255) not null,
        user_password varchar(255),
        user_role varchar(255) not null,
        primary key (id),
        unique (name)
    );

    create table gs_user_attribute (
        id bigint generated by default as identity,
        name varchar(255) not null,
        string varchar(255),
        user_id bigint not null,
        primary key (id),
        unique (name, user_id)
    );

    create table gs_user_favorites (
        user_id bigint not null,
        resource_id bigint not null,
        primary key (user_id, resource_id)
    );

    create table gs_user_group_attribute (
        id bigint generated by default as identity,
        name varchar(255) not null,
        string varchar(255),
        userGroup_id bigint not null,
        primary key (id)
    );

    create table gs_usergroup (
        id bigint generated by default as identity,
        description varchar(255),
        enabled char(255) not null,
        groupName varchar(255) not null,
        primary key (id),
        unique (groupName)
    );

    create table gs_usergroup_members (
        user_id bigint not null,
        group_id bigint not null,
        primary key (user_id, group_id)
    );

    alter table gs_attribute 
        add constraint FKA33E7B09410D3892 
        foreign key (resource_id) 
        references gs_resource;

    alter table gs_resource 
        add constraint FK9612B2016A775292 
        foreign key (category_id) 
        references gs_category;

    alter table gs_resource_tags 
        add constraint FK2AF25397410D3892 
        foreign key (resource_id) 
        references gs_resource 
        on delete cascade;

    alter table gs_resource_tags 
        add constraint FK2AF2539784998AE2 
        foreign key (tag_id) 
        references gs_tag;

    alter table gs_security 
        add constraint FKE2F965339EC981B7 
        foreign key (group_id) 
        references gs_usergroup;

    alter table gs_security 
        add constraint FKE2F9653362224F72 
        foreign key (user_id) 
        references gs_user;

    alter table gs_security 
        add constraint FKE2F96533410D3892 
        foreign key (resource_id) 
        references gs_resource;

    alter table gs_security_ip_range 
        add constraint FK7774E5B1D2CE1F53 
        foreign key (ip_range_id) 
        references gs_ip_range;

    alter table gs_security_ip_range 
        add constraint FK7774E5B1969DF26E 
        foreign key (security_id) 
        references gs_security;

    alter table gs_stored_data 
        add constraint FK8EDDBBF3410D3892 
        foreign key (resource_id) 
        references gs_resource;

    alter table gs_user_attribute 
        add constraint FK7F7AFADB62224F72 
        foreign key (user_id) 
        references gs_user;

    alter table gs_user_favorites 
        add constraint FK144ABA9662224F72 
        foreign key (user_id) 
        references gs_user;

    alter table gs_user_favorites 
        add constraint FK144ABA96410D3892 
        foreign key (resource_id) 
        references gs_resource 
        on delete cascade;

    alter table gs_user_group_attribute 
        add constraint FKDAC2ADDB6D297282 
        foreign key (userGroup_id) 
        references gs_usergroup;

    alter table gs_usergroup_members 
        add constraint FKFDE460DB9EC981B7 
        foreign key (group_id) 
        references gs_usergroup;

    alter table gs_usergroup_members 
        add constraint FKFDE460DB62224F72 
        foreign key (user_id) 
        references gs_user;
