/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao;

import it.geosolutions.geostore.core.dao.BaseDAOTest;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class CategoryDAOTest
extends BaseDAOTest {
    private static final Logger LOGGER = LogManager.getLogger(CategoryDAOTest.class);

    @Test
    public void testPersistCategory() throws Exception {
        String NAME = "NAME";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Category");
        }
        Category category = new Category();
        category.setName("MAP");
        categoryDAO.persist((Object[])new Category[]{category});
        long categoryId = category.getId();
        CategoryDAOTest.assertEquals((int)1, (int)categoryDAO.count(null));
        CategoryDAOTest.assertEquals((int)1, (int)categoryDAO.findAll().size());
        Resource resource = new Resource();
        resource.setName("NAME");
        resource.setCreation(new Date());
        resource.setCategory(category);
        resourceDAO.persist((Object[])new Resource[]{resource});
        long resourceId = resource.getId();
        CategoryDAOTest.assertEquals((int)1, (int)resourceDAO.count(null));
        CategoryDAOTest.assertEquals((int)1, (int)resourceDAO.findAll().size());
        Category loaded = (Category)categoryDAO.find(Long.valueOf(categoryId));
        CategoryDAOTest.assertNotNull((String)"Can't retrieve Category", (Object)loaded);
        CategoryDAOTest.assertEquals((String)"MAP", (String)loaded.getName());
        loaded.setName("SLD");
        categoryDAO.merge((Object)loaded);
        loaded = (Category)categoryDAO.find(Long.valueOf(categoryId));
        CategoryDAOTest.assertNotNull((String)"Can't retrieve Category", (Object)loaded);
        CategoryDAOTest.assertEquals((String)"MAP", (String)loaded.getName());
        categoryDAO.removeById(Long.valueOf(categoryId));
        CategoryDAOTest.assertNull((String)"Category not deleted", (Object)categoryDAO.find(Long.valueOf(categoryId)));
        CategoryDAOTest.assertNull((String)"Resource not deleted", (Object)resourceDAO.find(Long.valueOf(resourceId)));
    }
}

