/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.ldap;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ldap.BaseDAOTest;
import it.geosolutions.geostore.core.dao.ldap.impl.UserDAOImpl;
import it.geosolutions.geostore.core.dao.ldap.impl.UserGroupDAOImpl;
import it.geosolutions.geostore.core.ldap.MockContextSource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;

public class UserDAOTest
extends BaseDAOTest {
    @Test
    public void testFindAll() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setSearchBase("ou=users");
        List users = userDAO.findAll();
        Assert.assertEquals((long)2L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"username", (Object)user.getName());
    }

    @Test
    public void testSearchByName() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setSearchBase("ou=users");
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.equal((String)"name", (Object)"username")));
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"username", (Object)user.getName());
    }

    @Test
    public void testGroupsAreFetched() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setSearchBase("ou=users");
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        userDAO.setUserGroupDAO(userGroupDAO);
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.equal((String)"name", (Object)"username")));
        User user = (User)users.get(0);
        Assert.assertEquals((long)2L, (long)user.getGroups().size());
    }

    @Test
    public void testRolesAreAssigned() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setSearchBase("ou=users");
        userDAO.setAdminRoleGroup("admin");
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        userDAO.setUserGroupDAO(userGroupDAO);
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.equal((String)"name", (Object)"username")));
        User user = (User)users.get(0);
        Assert.assertEquals((Object)Role.ADMIN, (Object)user.getRole());
        search = new Search(User.class);
        users = userDAO.search((ISearch)search.addFilter(Filter.equal((String)"name", (Object)"username2")));
        user = (User)users.get(0);
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
    }

    @Test
    public void testAttributesMapper() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        HashMap<String, String> mapper = new HashMap<String, String>();
        mapper.put("mail", "email");
        userDAO.setAttributesMapper(mapper);
        userDAO.setSearchBase("ou=users");
        List users = userDAO.findAll();
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"username", (Object)user.getName());
        Assert.assertEquals((long)1L, (long)user.getAttribute().size());
        Assert.assertEquals((Object)"email", (Object)((UserAttribute)user.getAttribute().get(0)).getName());
    }

    @Test
    public void testSearchByGroup() {
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroupsMembership(null)));
        userGroupDAO.setSearchBase("ou=groups");
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setUserGroupDAO(userGroupDAO);
        userDAO.setSearchBase("ou=users");
        userGroupDAO.setUserDAO(userDAO);
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.some((String)"groups", (Filter)Filter.equal((String)"groupName", (Object)"group"))));
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"username", (Object)user.getName());
    }

    @Test
    public void testMemberPattern() {
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroupsMembership("uid=username,ou=users")));
        userGroupDAO.setSearchBase("ou=groups");
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setUserGroupDAO(userGroupDAO);
        userDAO.setSearchBase("ou=users");
        userDAO.setMemberPattern("^uid=([^,]+).*$");
        userGroupDAO.setUserDAO(userDAO);
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.some((String)"groups", (Filter)Filter.equal((String)"groupName", (Object)"group"))));
        Assert.assertEquals((long)1L, (long)users.size());
        User user = (User)users.get(0);
        Assert.assertEquals((Object)"username", (Object)user.getName());
    }

    @Test
    public void testGroupsAreFetchedWithoutNestedUsers() {
        UserDAOImpl userDAO = new UserDAOImpl((ContextSource)new MockContextSource(this.buildContextForUsers()));
        userDAO.setSearchBase("ou=users");
        UserGroupDAOImpl userGroupDAO = new UserGroupDAOImpl((ContextSource)new MockContextSource(this.buildContextForGroups()));
        userGroupDAO.setSearchBase("ou=groups");
        userDAO.setUserGroupDAO(userGroupDAO);
        Search search = new Search(User.class);
        List users = userDAO.search((ISearch)search.addFilter(Filter.equal((String)"name", (Object)"username")));
        User user = (User)users.get(0);
        Assert.assertEquals((long)2L, (long)user.getGroups().size());
        Assert.assertTrue((boolean)user.getGroups().stream().anyMatch(g -> g.getGroupName().equals("group")));
        for (UserGroup group : user.getGroups()) {
            Assert.assertTrue((boolean)group.getUsers().isEmpty());
        }
        Search search1 = new Search();
        Filter filter = Filter.equal((String)"groupName", (Object)"group");
        search1.addFilter(filter);
        List groups = userGroupDAO.search((ISearch)search1);
        Assert.assertFalse((boolean)((UserGroup)groups.get(0)).getUsers().isEmpty());
    }
}

