/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

public interface RESTCategoryService {
    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public long insert(@Context SecurityContext var1, @Multipart(value="category") Category var2) throws BadRequestServiceEx, NotFoundServiceEx;

    @PUT
    @Path(value="/category/{id}")
    @Consumes(value={"application/xml", "text/xml"})
    @Secured(value={"ROLE_ADMIN"})
    public long update(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="category") Category var4) throws NotFoundWebEx;

    @DELETE
    @Path(value="/category/{id}")
    @Secured(value={"ROLE_ADMIN"})
    public void delete(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @GET
    @Path(value="/category/{id}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public Category get(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @GET
    @Path(value="/")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public CategoryList getAll(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3) throws BadRequestWebEx;

    @GET
    @Path(value="/count/{nameLike}")
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public long getCount(@Context SecurityContext var1, @PathParam(value="nameLike") String var2);
}

