/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import java.text.ParseException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.springframework.security.access.annotation.Secured;

public interface RESTSessionService {
    @GET
    @Path(value="/user/{sessionId}")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public User getUser(@PathParam(value="sessionId") String var1, @DefaultValue(value="true") @QueryParam(value="refresh") boolean var2);

    @GET
    @Path(value="/username/{sessionId}")
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public String getUserName(@PathParam(value="sessionId") String var1, @DefaultValue(value="true") @QueryParam(value="refresh") boolean var2);

    @PUT
    @Path(value="/")
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public String createSession(@DefaultValue(value="") @QueryParam(value="expires") String var1, @Context SecurityContext var2) throws ParseException;

    @POST
    @Path(value="/login")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public SessionToken login(@Context SecurityContext var1) throws ParseException;

    @POST
    @Path(value="/refresh/{sessionId}/{refreshToken}")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public SessionToken refresh(@Context SecurityContext var1, @PathParam(value="sessionId") String var2, @PathParam(value="refreshToken") String var3) throws ParseException;

    @DELETE
    @Path(value="/{sessionId}")
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void removeSession(@PathParam(value="sessionId") String var1);

    @DELETE
    @Path(value="/")
    @Secured(value={"ROLE_ADMIN"})
    public void clear();
}

