/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ConflictWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.springframework.security.access.annotation.Secured;

public interface RESTMiscService {
    @GET
    @Path(value="/category/name/{cname}/resource/name/{rname}/data")
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public String getData(@Context SecurityContext var1, @PathParam(value="cname") String var2, @PathParam(value="rname") String var3) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/category/name/{cname}/resource/name/{rname}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public Resource getResource(@Context SecurityContext var1, @PathParam(value="cname") String var2, @PathParam(value="rname") String var3) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/category/name/{cname}/resources/")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ShortResourceList getResourcesByCategory(@Context SecurityContext var1, @PathParam(value="cname") String var2) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/category/name/{cname}/fullresources/")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ResourceList getResourcesByCategory(@Context SecurityContext var1, @PathParam(value="cname") String var2, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var3, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var4) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/reload/{service}")
    @Secured(value={"ROLE_ADMIN"})
    public void reload(@Context SecurityContext var1, @PathParam(value="service") String var2) throws BadRequestWebEx;
}

