/*
 * ====================================================================
 *
 * Copyright (C) 2007 - 2011 GeoSolutions S.A.S.
 * http://www.geo-solutions.it
 *
 * GPLv3 + Classpath exception
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * ====================================================================
 *
 * This software consists of voluntary contributions made by developers
 * of GeoSolutions.  For more information on GeoSolutions, please see
 * <http://www.geo-solutions.it/>.
 *
 */
package it.geosolutions.geostore.services.rest.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class RESTStoredData.
 *
 * @author Tobia di Pisa (tobia.dipisa at geo-solutions.it)
 */
@XmlRootElement(name = "StoredData")
public class RESTStoredData implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -7571757460032518456L;

    /** The id. */
    private Long id;

    private String data;

    /** Instantiates a new instance. */
    public RESTStoredData() {}

    /** Instantiates a new instance. */
    public RESTStoredData(String data) {
        this.data = data;
    }

    /** @return the id */
    public Long getId() {
        return id;
    }

    /** @param id the id to set */
    public void setId(long id) {
        this.id = id;
    }

    /** @return the data */
    public String getData() {
        return data;
    }

    /** @param data the data to set */
    public void setData(String data) {
        this.data = data;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(getClass().getSimpleName()).append('[');

        builder.append("id=").append(id).append(", ");

        if (data != null) builder.append("data=").append(data);

        builder.append(']');
        return builder.toString();
    }
}
