/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import it.geosolutions.geostore.services.rest.auditing.AuditingException;
import java.io.File;
import org.apache.commons.io.FileUtils;

final class AuditingTemplates {
    private static final String HEADER = "header.ftl";
    private static final String BODY = "body.ftl";
    private static final String FOOTER = "footer.ftl";
    private final File templatesDirectory;
    private final Template headerTemplate;
    private final Template bodyTemplate;
    private final Template footerTemplate;
    private final long headerTemplateChecksum;
    private final long bodyTemplateChecksum;
    private final long footerTemplateChecksum;

    AuditingTemplates(String templatesDirectoryPath) {
        this(templatesDirectoryPath, null, null, null);
    }

    AuditingTemplates(String templatesDirectoryPath, Long headerTemplateChecksum, Long bodyTemplateChecksum, Long footerTemplateChecksum) {
        this.templatesDirectory = this.getTemplatesDirectory(templatesDirectoryPath);
        Configuration configuration = this.getConfiguration();
        this.headerTemplate = this.getTemplate(configuration, HEADER);
        this.bodyTemplate = this.getTemplate(configuration, BODY);
        this.footerTemplate = this.getTemplate(configuration, FOOTER);
        this.headerTemplateChecksum = headerTemplateChecksum == null ? this.checksum(new File(this.templatesDirectory, HEADER)) : headerTemplateChecksum.longValue();
        this.bodyTemplateChecksum = bodyTemplateChecksum == null ? this.checksum(new File(this.templatesDirectory, BODY)) : bodyTemplateChecksum.longValue();
        this.footerTemplateChecksum = footerTemplateChecksum == null ? this.checksum(new File(this.templatesDirectory, FOOTER)) : footerTemplateChecksum.longValue();
    }

    Template getHeaderTemplate() {
        return this.headerTemplate;
    }

    Template getBodyTemplate() {
        return this.bodyTemplate;
    }

    Template getFooterTemplate() {
        return this.footerTemplate;
    }

    AuditingTemplates checkForNewTemplates(String candidateTemplatesDirectoryPath) {
        File candidateTemplatesDirectory = this.getTemplatesDirectory(candidateTemplatesDirectoryPath);
        long candidateHeaderTemplateChecksum = this.checksum(new File(this.templatesDirectory, HEADER));
        long candidateBodyTemplateChecksum = this.checksum(new File(this.templatesDirectory, BODY));
        long candidateFooterTemplateChecksum = this.checksum(new File(this.templatesDirectory, FOOTER));
        if (this.templatesDirectory.compareTo(candidateTemplatesDirectory) != 0 || this.headerTemplateChecksum == candidateHeaderTemplateChecksum || this.bodyTemplateChecksum == candidateBodyTemplateChecksum || this.footerTemplateChecksum == candidateFooterTemplateChecksum) {
            return new AuditingTemplates(candidateTemplatesDirectoryPath, candidateHeaderTemplateChecksum, candidateBodyTemplateChecksum, candidateFooterTemplateChecksum);
        }
        return null;
    }

    private File getTemplatesDirectory(String templatesDirectoryPath) {
        File file = new File(templatesDirectoryPath);
        if (!file.exists()) {
            throw new AuditingException("Templates directory '%s' does not exists.", templatesDirectoryPath);
        }
        return file;
    }

    private Configuration getConfiguration() {
        try {
            Configuration configuration = new Configuration();
            configuration.setDirectoryForTemplateLoading(this.templatesDirectory);
            configuration.setDefaultEncoding("UTF-8");
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            return configuration;
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error initiating templates configuration from directory '%s'.", this.templatesDirectory.getPath());
        }
    }

    private Template getTemplate(Configuration configuration, String templateName) {
        try {
            return configuration.getTemplate(templateName);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error getting template '%s'.", templateName);
        }
    }

    private long checksum(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error computign checksum of file '%s'.", file.getPath());
        }
    }
}

