/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingConfiguration;
import it.geosolutions.geostore.services.rest.auditing.AuditingException;
import it.geosolutions.geostore.services.rest.auditing.AuditingFilesManager;
import it.geosolutions.geostore.services.rest.auditing.AuditingTemplates;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class AuditingOutput {
    private static final Logger LOGGER = LogManager.getLogger(AuditingOutput.class);
    private final BlockingQueue<Map<String, String>> messagesQueue = new ArrayBlockingQueue<Map<String, String>>(10000);
    private AuditingConfiguration configuration;
    private AuditingTemplates templates;
    private AuditingFilesManager auditingFilesManager;
    private boolean auditEnable = false;
    private FileWriter writer;
    private int requestsProcessed;

    AuditingOutput() {
        if (AuditingConfiguration.configurationExists()) {
            this.configuration = new AuditingConfiguration();
            if (this.configuration.isAuditEnable()) {
                LOGGER.info("Auditing enable.");
                this.auditEnable = true;
                this.templates = new AuditingTemplates(this.configuration.getTemplatesDirectory());
                this.auditingFilesManager = new AuditingFilesManager(this.configuration.getOutputDirectory(), this.configuration.getOutputFilesExtension());
                this.openWriter();
                final Consumer consumer = new Consumer();
                final Thread consumerThread = new Thread(consumer);
                consumerThread.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        consumer.running = false;
                        try {
                            consumerThread.interrupt();
                            consumerThread.join(500L);
                        }
                        catch (InterruptedException exception) {
                            LOGGER.error("Interrupted when waiting for consumer thread.", (Throwable)exception);
                        }
                        AuditingOutput.this.closeWriter();
                    }
                });
            } else {
                LOGGER.info("Auditing not enable.");
            }
        } else {
            LOGGER.info("Auditing configuration not found, audit disabled.");
        }
    }

    void offerMessage(Map<String, String> message) {
        if (this.auditEnable) {
            try {
                this.messagesQueue.offer(message);
            }
            catch (Exception exception) {
                LOGGER.error("Error offering message.", (Throwable)exception);
            }
        }
    }

    boolean isAuditEnable() {
        return this.auditEnable;
    }

    AuditingFilesManager getAuditingFilesManager() {
        return this.auditingFilesManager;
    }

    private void openWriter() {
        try {
            this.writer = new FileWriter(this.auditingFilesManager.getOutputFile());
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error open writer for file output '%s'.", this.auditingFilesManager.getOutputFile().getPath());
        }
        try {
            this.templates.getHeaderTemplate().process((Object)Collections.EMPTY_MAP, (Writer)this.writer);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error writing header to file '%s'.", this.auditingFilesManager.getOutputFile().getPath());
        }
    }

    private void closeWriter() {
        try {
            this.templates.getFooterTemplate().process((Object)Collections.EMPTY_MAP, (Writer)this.writer);
        }
        catch (Exception exception) {
            throw new AuditingException("Error writing footer to file output '%s'.", this.auditingFilesManager.getOutputFile().getPath());
        }
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            throw new AuditingException("Error closing writer for file output '%s'.", this.auditingFilesManager.getOutputFile().getPath());
        }
    }

    private void processMessage(Map<String, String> message) {
        this.auditingFilesManager.makeOutputFileExists();
        try {
            message.put("id", String.valueOf(this.requestsProcessed));
            this.templates.getBodyTemplate().process(message, (Writer)this.writer);
        }
        catch (Exception exception) {
            LOGGER.error("Error writing to body template.", (Throwable)exception);
        }
        ++this.requestsProcessed;
        if (this.requestsProcessed >= this.configuration.getMaxRequestPerFile()) {
            this.closeWriter();
            this.auditingFilesManager.rollOutputFile();
            this.openWriter();
            this.requestsProcessed = 0;
        }
    }

    private class Consumer
    implements Runnable {
        volatile boolean running = true;

        private Consumer() {
        }

        @Override
        public void run() {
            while (this.running) {
                ArrayList<Map<String, String>> messages = new ArrayList<Map<String, String>>();
                try {
                    if (AuditingOutput.this.messagesQueue.isEmpty()) {
                        messages.add(AuditingOutput.this.messagesQueue.take());
                    } else {
                        AuditingOutput.this.messagesQueue.drainTo(messages);
                    }
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                }
                for (Map map : messages) {
                    try {
                        AuditingOutput.this.processMessage(map);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error processing message.", (Throwable)exception);
                    }
                }
            }
        }
    }
}

