/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingTestsUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;

public abstract class AuditingTestsBase {
    protected final File TESTS_ROOT_DIRECTORY = new File(System.getProperty("java.io.tmpdir"), "auditing-tests-" + UUID.randomUUID().toString());
    protected final File OUTPUT_DIRECTORY = new File(this.TESTS_ROOT_DIRECTORY, "output");
    protected final File TEMPLATES_DIRECTORY = this.getTemplatesDirectory();
    protected final File CONFIGURATION_DIRECTORY = new File(this.TESTS_ROOT_DIRECTORY, "configuration");
    protected final File CONFIGURATION_FILE_PATH = new File(this.CONFIGURATION_DIRECTORY, "auditing.properties");

    private File getTemplatesDirectory() {
        try {
            return new File(AuditingTestsUtils.class.getClassLoader().getResource("templates").toURI().getPath());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Error getting tests templates directory.");
        }
    }

    @Before
    public void before() {
        AuditingTestsUtils.initDirectory(this.TESTS_ROOT_DIRECTORY);
        AuditingTestsUtils.createDefaultConfiguration(this.CONFIGURATION_DIRECTORY, this.CONFIGURATION_FILE_PATH, this.OUTPUT_DIRECTORY, this.TEMPLATES_DIRECTORY);
        AuditingTestsUtils.initDirectory(this.OUTPUT_DIRECTORY);
    }

    @After
    public void after() {
        AuditingTestsUtils.deleteDirectory(this.TESTS_ROOT_DIRECTORY);
    }
}

