/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.MapExpressionUserMapper;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.GeoStoreRequestHeadersAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoStoreAuthenticationFilterTest {
    private static final String USERNAME_HEADER = "username";
    private static final String SAMPLE_USER = "myuser";
    private MockedUserService userService;
    private GeoStoreRequestHeadersAuthenticationFilter filter;
    private HttpServletRequest req;
    private HttpServletResponse resp;

    @Before
    public void setUp() {
        this.userService = new MockedUserService();
        this.filter = new GeoStoreRequestHeadersAuthenticationFilter();
        this.filter.setUserNameHeader(USERNAME_HEADER);
        this.filter.setUserService((UserService)this.userService);
        this.filter.setAutoCreateUser(true);
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.req.getHeader(USERNAME_HEADER)).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.req.getHeader("header1")).thenReturn((Object)"value1");
        Mockito.when((Object)this.req.getHeaderNames()).thenReturn(new Vector<String>(Arrays.asList(USERNAME_HEADER, "header1")).elements());
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testAutoCreate() throws IOException, ServletException, NotFoundServiceEx {
        this.filter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        Assert.assertTrue((boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateDisabled() throws IOException, ServletException, NotFoundServiceEx {
        this.filter.setEnableAutoCreatedUsers(false);
        this.filter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        Assert.assertFalse((boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateAttributesMapping() throws IOException, ServletException, NotFoundServiceEx {
        HashMap<String, String> attributeMappings = new HashMap<String, String>();
        attributeMappings.put("attr1", "header1");
        this.filter.setUserMapper((UserMapper)new MapExpressionUserMapper(attributeMappings));
        this.filter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        List attributes = user.getAttribute();
        Assert.assertEquals((long)1L, (long)attributes.size());
        Assert.assertEquals((Object)"attr1", (Object)((UserAttribute)attributes.get(0)).getName());
        Assert.assertEquals((Object)"value1", (Object)((UserAttribute)attributes.get(0)).getValue());
    }

    private void checkUser(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
        Assert.assertTrue((boolean)user.getGroups().isEmpty());
    }
}

