/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.utils.AbstractGeoStoreAuthenticationInterceptor;
import it.geosolutions.geostore.services.rest.utils.NewPasswordStrategy;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;

public class AutoUserCreateGeostoreAuthenticationInterceptor
extends AbstractGeoStoreAuthenticationInterceptor {
    private UserService userService;
    private Boolean autoCreateUsers = false;
    private Role newUsersRole = Role.USER;
    private NewPasswordStrategy newUsersPassword = NewPasswordStrategy.NONE;
    private String newUsersPasswordHeader = "";

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setAutoCreateUsers(Boolean autoCreateUsers) {
        this.autoCreateUsers = autoCreateUsers;
    }

    public void setNewUsersRole(Role newUsersRole) {
        this.newUsersRole = newUsersRole;
    }

    public void setNewUsersPassword(NewPasswordStrategy newUsersPassword) {
        this.newUsersPassword = newUsersPassword;
    }

    public void setNewUsersPasswordHeader(String newUsersPasswordHeader) {
        this.newUsersPasswordHeader = newUsersPasswordHeader;
    }

    private String getNewUserPassword(Message message, String username) {
        switch (this.newUsersPassword) {
            case NONE: {
                return "";
            }
            case USERNAME: {
                return username;
            }
            case FROMHEADER: {
                Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
                if (headers.containsKey(this.newUsersPasswordHeader)) {
                    return (String)((List)headers.get(this.newUsersPasswordHeader)).get(0);
                }
                return "";
            }
        }
        return "";
    }

    @Override
    protected User getUser(String username, Message message) {
        User user = null;
        try {
            user = this.userService.get(username);
        }
        catch (NotFoundServiceEx e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Requested user not found: " + username);
            }
            if (this.autoCreateUsers.booleanValue()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Creating now");
                }
                user = new User();
                user.setName(username);
                user.setNewPassword(this.getNewUserPassword(message, username));
                user.setRole(this.newUsersRole);
                try {
                    user.setId(Long.valueOf(this.userService.insert(user)));
                    user = this.userService.get(username);
                }
                catch (Exception e1) {
                    throw new AccessDeniedException("Not able to create new user");
                }
            }
            throw new AccessDeniedException("Not authorized");
        }
        return user;
    }
}

