/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationFilter;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;

public class UserAttributeTokenAuthenticationFilter
extends TokenAuthenticationFilter {
    private static final Logger LOGGER = LogManager.getLogger(UserAttributeTokenAuthenticationFilter.class);
    private String attributeName = "UUID";

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    protected Authentication checkToken(String token) {
        UserAttribute attribute = new UserAttribute();
        attribute.setName(this.attributeName);
        attribute.setValue(token);
        Collection users = this.userService.getByAttribute(attribute);
        if (users.size() == 1) {
            User user = (User)users.iterator().next();
            return this.createAuthenticationForUser(user);
        }
        if (users.size() > 1) {
            LOGGER.error("Too many users matching the given token. Only one is allowed for a token to be valid!");
        } else {
            LOGGER.error("No users matching the given token.");
        }
        return null;
    }
}

