/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.web.filter.GenericFilterBean;

public abstract class GeoStoreAuthenticationFilter
extends GenericFilterBean {
    public static final String USER_NOT_FOUND_MSG = "User not found. Please check your credentials";
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreAuthenticationFilter.class);
    @Autowired
    protected UserService userService;
    private boolean autoCreateUser = false;
    private boolean enableAutoCreatedUsers = true;
    private UserMapper userMapper;

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            this.authenticate((HttpServletRequest)req);
        }
        chain.doFilter(req, resp);
    }

    protected abstract void authenticate(HttpServletRequest var1);

    protected Authentication createAuthenticationForUser(String userName, String credentials, Object rawUser) {
        User user = null;
        try {
            user = this.userService.get(userName);
        }
        catch (NotFoundServiceEx e) {
            if (this.autoCreateUser) {
                try {
                    user = this.createUser(userName, credentials, rawUser);
                }
                catch (BadRequestServiceEx e1) {
                    LOGGER.error("Error creating user for " + userName, (Throwable)e);
                }
                catch (NotFoundServiceEx e1) {
                    LOGGER.error("Error creating user for " + userName, (Throwable)e);
                }
            }
            LOGGER.error("User not found: " + userName, (Throwable)e);
        }
        return this.createAuthenticationForUser(user);
    }

    protected User createUser(String userName, String credentials, Object rawUser) throws BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(userName);
        user.setNewPassword(credentials);
        user.setEnabled(this.enableAutoCreatedUsers);
        Role role = Role.USER;
        user.setRole(role);
        user.setGroups(Collections.EMPTY_SET);
        if (this.userMapper != null) {
            this.userMapper.mapUser(rawUser, user);
        }
        if (this.userService != null) {
            this.userService.insert(user);
        }
        return user;
    }

    protected Authentication createAuthenticationForUser(User user) {
        if (user != null) {
            String role = user.getRole().toString();
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
            return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), authorities);
        }
        LOGGER.error(USER_NOT_FOUND_MSG);
        return null;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }

    public void setAutoCreateUser(boolean autoCreateUser) {
        this.autoCreateUser = autoCreateUser;
    }

    public void setEnableAutoCreatedUsers(boolean enableAutoCreatedUsers) {
        this.enableAutoCreatedUsers = enableAutoCreatedUsers;
    }
}

