/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTBackupService;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTQuickBackup;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.utils.Convert;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTBackupServiceImpl
extends RESTServiceImpl
implements RESTBackupService {
    private static final Logger LOGGER = LogManager.getLogger(RESTBackupServiceImpl.class);
    private static final long MAX_RESOURCES_FOR_QUICK_BACKUP = 100L;
    private CategoryService categoryService;
    private ResourceService resourceService;

    private static Category rbc2cat(RESTQuickBackup.RESTBackupCategory rbc) {
        Category ret = new Category();
        ret.setName(rbc.getName());
        return ret;
    }

    public String backup(SecurityContext sc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String restore(SecurityContext sc, String token) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RESTQuickBackup quickBackup(SecurityContext sc) throws BadRequestServiceEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("quickBackup()");
        }
        if (this.resourceService.getCount(null) > 100L) {
            throw new BadRequestServiceEx("Too many resources for a quick backup");
        }
        RESTQuickBackup backup = new RESTQuickBackup();
        try {
            List categories = this.categoryService.getAll(null, null);
            for (Category category : categories) {
                RESTQuickBackup.RESTBackupCategory bc = this.createCategory(category);
                backup.addCategory(bc);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new InternalErrorWebEx("Internal error while performing backup");
        }
        return backup;
    }

    public String quickRestore(SecurityContext sc, RESTQuickBackup backup) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("quickRestore()");
        }
        try {
            LOGGER.error("Deleting all categories");
            for (Category category : this.categoryService.getAll(null, null)) {
                this.categoryService.delete(category.getId().longValue());
            }
            LOGGER.error("Deleting all resources");
            for (ShortResource shortResource : this.resourceService.getAll(ResourceSearchParameters.builder().build())) {
                this.resourceService.delete(shortResource.getId());
            }
            for (RESTQuickBackup.RESTBackupCategory rbc : backup.getCategories()) {
                this.quickRestoreCategory(rbc);
            }
            return "ok";
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new InternalErrorWebEx(ex.getMessage());
        }
    }

    private void quickRestoreCategory(RESTQuickBackup.RESTBackupCategory rbc) throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx {
        LOGGER.info("Restoring category: " + rbc.getName());
        Category cat = RESTBackupServiceImpl.rbc2cat(rbc);
        long catId = this.categoryService.insert(cat);
        for (RESTQuickBackup.RESTBackupResource rbr : rbc.getResources()) {
            if (LOGGER.isInfoEnabled()) {
                int attnum;
                int n = attnum = rbr != null && rbr.getResource() != null && rbr.getResource().getAttribute() != null ? rbr.getResource().getAttribute().size() : -1;
                assert (rbr != null);
                LOGGER.info("Restoring resource: {}:{} ({} attrs)", (Object)cat.getName(), (Object)rbr.getResource().getName(), (Object)attnum);
            }
            Resource res = this.rbr2res(rbr, catId);
            this.resourceService.insert(res);
        }
    }

    private Resource rbr2res(RESTQuickBackup.RESTBackupResource rbr, long catId) {
        Resource ret = Convert.convertResource(rbr.getResource());
        ret.getCategory().setId(Long.valueOf(catId));
        return ret;
    }

    private RESTQuickBackup.RESTBackupCategory createCategory(Category category) throws BadRequestServiceEx, InternalErrorServiceEx {
        LOGGER.info("Packing category " + category.getName());
        RESTQuickBackup.RESTBackupCategory ret = new RESTQuickBackup.RESTBackupCategory();
        ret.setName(category.getName());
        CategoryFilter filter = new CategoryFilter(category.getName(), SearchOperator.EQUAL_TO);
        List resList = this.resourceService.getResourcesFull(ResourceSearchParameters.builder().filter((SearchFilter)filter).build());
        for (Resource resource : resList) {
            RESTQuickBackup.RESTBackupResource rbe = this.createResource(resource);
            ret.addResource(rbe);
        }
        return ret;
    }

    private RESTQuickBackup.RESTBackupResource createResource(Resource resource) {
        LOGGER.info("Packing resource " + resource.getName());
        RESTResource rr = this.createRESTResource(resource);
        RESTQuickBackup.RESTBackupResource rbr = new RESTQuickBackup.RESTBackupResource();
        rbr.setResource(rr);
        return rbr;
    }

    private RESTResource createRESTResource(Resource resource) {
        RESTResource ret = new RESTResource();
        ret.setCategory(new RESTCategory(resource.getCategory().getName()));
        ret.setName(resource.getName());
        ret.setDescription(resource.getDescription());
        ret.setMetadata(resource.getMetadata());
        ret.setCreator(resource.getCreator());
        ret.setEditor(resource.getEditor());
        ret.setAdvertised(resource.isAdvertised().booleanValue());
        if (resource.getData() != null) {
            ret.setData(resource.getData().getData());
        }
        if (CollectionUtils.isNotEmpty((Collection)resource.getAttribute())) {
            ret.setAttribute(Convert.convertToShortAttributeList(resource.getAttribute()));
        }
        return ret;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @Override
    protected SecurityService getSecurityService() {
        throw new NotImplementedException("This method is not implemented yet...");
    }
}

