/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.AuthoritiesMappings;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class KeyCloakConfiguration
extends IdPConfiguration {
    private String jsonConfig;
    private AdapterConfig config;
    private Boolean forceConfiguredRedirectURI;
    private Map<String, String> roleMappings;
    private Map<String, String> groupMappings;
    private boolean dropUnmapped = false;

    public String getJsonConfig() {
        return this.jsonConfig;
    }

    public void setJsonConfig(String jsonConfig) {
        this.jsonConfig = jsonConfig;
        if (this.config != null && StringUtils.isNotBlank((String)this.jsonConfig)) {
            this.config = KeycloakDeploymentBuilder.loadAdapterConfig((InputStream)IOUtils.toInputStream((String)this.getJsonConfig()));
        }
    }

    private Map<String, String> toMap(String mappings) {
        if (mappings != null) {
            String[] keyValues = mappings.split(",");
            AuthoritiesMappings map = new AuthoritiesMappings(keyValues.length);
            for (String keyValue : keyValues) {
                String[] keyValueAr = keyValue.split(":");
                map.put(keyValueAr[0], keyValueAr[1]);
            }
            return map;
        }
        return null;
    }

    public Map<String, String> getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(String roleMappings) {
        this.roleMappings = this.toMap(roleMappings);
    }

    public Map<String, String> getGroupMappings() {
        return this.groupMappings;
    }

    public void setGroupMappings(String groupMappings) {
        this.groupMappings = this.toMap(groupMappings);
    }

    public boolean isDropUnmapped() {
        return this.dropUnmapped;
    }

    public void setDropUnmapped(boolean dropUnmapped) {
        this.dropUnmapped = dropUnmapped;
    }

    public AdapterConfig readAdapterConfig() {
        String jsonConfig = this.getJsonConfig();
        if (this.config == null && StringUtils.isNotBlank((String)jsonConfig)) {
            this.config = KeycloakDeploymentBuilder.loadAdapterConfig((InputStream)IOUtils.toInputStream((String)jsonConfig));
            this.config.setTokenStore(TokenStore.COOKIE.name());
        }
        return this.config;
    }

    public Boolean getForceConfiguredRedirectURI() {
        if (this.forceConfiguredRedirectURI == null) {
            return false;
        }
        return this.forceConfiguredRedirectURI;
    }

    public void setForceConfiguredRedirectURI(Boolean forceConfiguredRedirectURI) {
        this.forceConfiguredRedirectURI = forceConfiguredRedirectURI;
    }
}

