/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.model.enums.UserReservedNames;
import it.geosolutions.geostore.services.ResourcePermissionService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class RESTServiceImpl {
    private static final Logger LOGGER = LogManager.getLogger(RESTServiceImpl.class);
    @Autowired
    UserService userService;
    @Autowired
    ResourceService resourceService;
    @Autowired
    ResourcePermissionService resourcePermissionService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setResourcePermissionService(ResourcePermissionService resourcePermissionService) {
        this.resourcePermissionService = resourcePermissionService;
    }

    protected User extractAuthUser(SecurityContext sc) throws InternalErrorWebEx {
        if (sc == null) {
            throw new InternalErrorWebEx("Missing auth info");
        }
        Principal principal = sc.getUserPrincipal();
        if (principal == null) {
            principal = this.createGuestPrincipal();
        }
        if (!(principal instanceof Authentication)) {
            RESTServiceImpl.logMismatchedPrincipal();
            throw new InternalErrorWebEx("Mismatching auth principal (" + String.valueOf(principal.getClass()) + ")");
        }
        Authentication usrToken = (Authentication)principal;
        if (usrToken.getPrincipal() instanceof User) {
            User user = (User)usrToken.getPrincipal();
            user.setIpAddress(this.extractClientIp());
            LOGGER.info("Accessing service with user '{}', role '{}', and IP '{}'", (Object)user.getName(), (Object)user.getRole(), (Object)user.getIpAddress());
            return user;
        }
        RESTServiceImpl.logMismatchedPrincipal();
        throw new InternalErrorWebEx("Mismatching auth principal (not a GeoStore User)");
    }

    public String extractClientIp() {
        return this.extractClientIpFromRequest(((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
    }

    private String extractClientIpFromRequest(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip)) {
            return ip.split(",")[0];
        }
        ip = request.getHeader("X-Real-IP");
        if (ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    private static void logMismatchedPrincipal() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Mismatching auth principal");
        }
    }

    public boolean resourceAccessWrite(User user, long resourceId) {
        Resource resource = this.resourceService.getResource(resourceId, false, true, false);
        return this.resourcePermissionService.canResourceBeWrittenByUser(resource, user);
    }

    public boolean resourceAccessRead(User user, long resourceId) {
        Resource resource = this.resourceService.getResource(resourceId, false, true, false);
        return this.resourcePermissionService.canResourceBeReadByUser(resource, user);
    }

    public Principal createGuestPrincipal() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_GUEST"));
        try {
            User u = this.userService.get(UserReservedNames.GUEST.userName());
            return new UsernamePasswordAuthenticationToken((Object)u, (Object)"", authorities);
        }
        catch (NotFoundServiceEx e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User GUEST is not configured, creating on-the-fly a default one");
            }
            User guest = new User();
            guest.setName("guest");
            guest.setRole(Role.GUEST);
            HashSet<UserGroup> groups = new HashSet<UserGroup>();
            UserGroup everyoneGroup = new UserGroup();
            everyoneGroup.setEnabled(true);
            everyoneGroup.setId(Long.valueOf(-1L));
            everyoneGroup.setGroupName(GroupReservedNames.EVERYONE.groupName());
            groups.add(everyoneGroup);
            guest.setGroups(groups);
            return new UsernamePasswordAuthenticationToken((Object)guest, (Object)"", authorities);
        }
    }

    public static String convertNameLikeToSqlSyntax(String nameLike) {
        if (nameLike == null) {
            return null;
        }
        return nameLike.replaceAll("[*]", "%");
    }
}

