/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.impl.RESTSessionServiceImpl;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleOAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleSessionServiceDelegate;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OAuthGoogleSecurityConfiguration;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OAuth2SessionServiceTest {
    private static final String ID_TOKEN = "test.id.token";
    private static final String ACCESS_TOKEN = "access_token";

    @Test
    public void testLogout() {
        GoogleOAuth2Configuration configuration = new GoogleOAuth2Configuration();
        configuration.setEnabled(true);
        configuration.setIdTokenUri("https://www.googleapis.com/oauth2/v3/certs");
        configuration.setRevokeEndpoint("http://google.foo");
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(ACCESS_TOKEN);
        TokenDetails details = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)details.getProvider()).thenReturn((Object)"google");
        Mockito.when((Object)details.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)details.getIdToken()).thenReturn((Object)ID_TOKEN);
        authenticationToken.setDetails((Object)details);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        GeoStoreOAuthRestTemplate restTemplate = new GeoStoreOAuthRestTemplate(new OAuthGoogleSecurityConfiguration().resourceDetails(), (OAuth2ClientContext)new DefaultOAuth2ClientContext(), (OAuth2Configuration)configuration);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        HashMap<String, GoogleOAuth2Configuration> configurations = new HashMap<String, GoogleOAuth2Configuration>();
        configurations.put("googleOAuth2Config", configuration);
        try (MockedStatic utilities = Mockito.mockStatic(GeoStoreContext.class);){
            utilities.when(() -> GeoStoreContext.beans(OAuth2Configuration.class)).thenReturn(configurations);
            utilities.when(() -> GeoStoreContext.bean((String)"googleOAuth2Config", OAuth2Configuration.class)).thenReturn((Object)configuration);
            utilities.when(() -> GeoStoreContext.bean((String)"oAuth2Cache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            utilities.when(() -> GeoStoreContext.bean((String)"googleOpenIdRestTemplate", OAuth2RestTemplate.class)).thenReturn((Object)restTemplate);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setParameter(ACCESS_TOKEN, ACCESS_TOKEN);
            request.setUserPrincipal((Principal)authenticationToken);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"google", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new GoogleSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)response.getStatus(), (long)200L);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            Assert.assertNull((Object)request.getUserPrincipal());
        }
    }
}

