/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.utils.AutoUserCreateGeostoreAuthenticationInterceptor;
import it.geosolutions.geostore.services.rest.utils.BaseAuthenticationInterceptorTest;
import it.geosolutions.geostore.services.rest.utils.NewPasswordStrategy;
import java.util.HashMap;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AutoUserCreateGeostoreAuthenticationInterceptorTest
extends BaseAuthenticationInterceptorTest {
    @Ignore
    @Test(expected=AccessDeniedException.class)
    public void testNotCreateUsers() {
        AutoUserCreateGeostoreAuthenticationInterceptor interceptor = new AutoUserCreateGeostoreAuthenticationInterceptor();
        interceptor.setAutoCreateUsers(Boolean.valueOf(false));
        interceptor.setUserService(this.userService);
        interceptor.handleMessage(this.getMockedMessage("test", "", null));
    }

    @Ignore
    @Test
    public void testCreateUsers() {
        AutoUserCreateGeostoreAuthenticationInterceptor interceptor = new AutoUserCreateGeostoreAuthenticationInterceptor();
        interceptor.setAutoCreateUsers(Boolean.valueOf(true));
        interceptor.setNewUsersPassword(NewPasswordStrategy.NONE);
        interceptor.setUserService(this.userService);
        interceptor.handleMessage(this.getMockedMessage("test", "", null));
        try {
            User user = this.userService.get("test");
            Assert.assertNotNull((Object)user);
        }
        catch (NotFoundServiceEx e) {
            Assert.fail((String)"Couldn't found user");
        }
    }

    @Ignore
    @Test
    public void testCreateUsersStrategyUserName() {
        AutoUserCreateGeostoreAuthenticationInterceptor interceptor = new AutoUserCreateGeostoreAuthenticationInterceptor();
        interceptor.setAutoCreateUsers(Boolean.valueOf(true));
        interceptor.setNewUsersPassword(NewPasswordStrategy.USERNAME);
        interceptor.setUserService(this.userService);
        interceptor.handleMessage(this.getMockedMessage("test2", "test2", null));
        try {
            User user = this.userService.get("test2");
            Assert.assertNotNull((Object)user);
        }
        catch (NotFoundServiceEx e) {
            Assert.fail((String)"Couldn't found user");
        }
    }

    @Ignore
    @Test
    public void testCreateUsersStrategyFromHeader() {
        AutoUserCreateGeostoreAuthenticationInterceptor interceptor = new AutoUserCreateGeostoreAuthenticationInterceptor();
        interceptor.setAutoCreateUsers(Boolean.valueOf(true));
        interceptor.setNewUsersPassword(NewPasswordStrategy.FROMHEADER);
        interceptor.setNewUsersPasswordHeader("newPassword");
        interceptor.setUserService(this.userService);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("newPassword", "test3pass");
        interceptor.handleMessage(this.getMockedMessage("test3", "test3pass", headers));
        try {
            User user = this.userService.get("test3");
            Assert.assertNotNull((Object)user);
        }
        catch (NotFoundServiceEx e) {
            Assert.fail((String)"Couldn't found user");
        }
    }
}

