/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.google.common.collect.Lists;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.JWTHelper;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class OAuth2GeoStoreAuthenticationFilter
extends OAuth2ClientAuthenticationProcessingFilter {
    private static final Logger LOGGER = LogManager.getLogger(OAuth2GeoStoreAuthenticationFilter.class);
    private static final String SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME = "sourceService";
    public static final String OAUTH2_AUTHENTICATION_KEY = "oauth2.authentication";
    public static final String OAUTH2_AUTHENTICATION_TYPE_KEY = "oauth2.authenticationType";
    public static final String OAUTH2_ACCESS_TOKEN_CHECK_KEY = "oauth2.AccessTokenCheckResponse";
    private final AuthenticationEntryPoint authEntryPoint;
    private final TokenAuthenticationCache cache;
    @Autowired
    protected UserService userService;
    @Autowired
    protected UserGroupService userGroupService;
    protected RemoteTokenServices tokenServices;
    protected OAuth2Configuration configuration;

    public OAuth2GeoStoreAuthenticationFilter(RemoteTokenServices tokenServices, GeoStoreOAuthRestTemplate oAuth2RestTemplate, OAuth2Configuration configuration, TokenAuthenticationCache tokenAuthenticationCache) {
        super("/**");
        super.setTokenServices((ResourceServerTokenServices)tokenServices);
        this.tokenServices = tokenServices;
        this.restTemplate = oAuth2RestTemplate;
        this.configuration = configuration;
        this.authEntryPoint = configuration.getAuthenticationEntryPoint();
        this.cache = tokenAuthenticationCache;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserGroupService getUserGroupService() {
        return this.userGroupService;
    }

    public void setUserGroupService(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    public RemoteTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(RemoteTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public OAuth2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuth2Configuration configuration) {
        this.configuration = configuration;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.configuration.isEnabled() && !this.configuration.isInvalid() && authentication == null) {
            super.doFilter(req, res, chain);
        } else if (req instanceof HttpServletRequest) {
            this.addRequestAttributes((HttpServletRequest)req, authentication);
        }
        if (this.configuration.isEnabled() && this.configuration.isInvalid() && LOGGER.isDebugEnabled()) {
            LOGGER.info("Skipping configured OAuth2 authentication. One or more mandatory properties are missing (clientId, clientSecret, authorizationUri, tokenUri).");
        }
        chain.doFilter(req, res);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication;
        String token = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        if (token != null) {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
        } else {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.USER);
        }
        if (token != null) {
            authentication = this.cache.get(token);
            if (authentication == null) {
                authentication = this.authenticateAndUpdateCache(request, response, token, (OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            } else {
                OAuth2AccessToken accessToken;
                TokenDetails details = this.tokenDetails(authentication);
                if (details != null && (accessToken = details.getAccessToken()).isExpired()) {
                    authentication = this.authenticateAndUpdateCache(request, response, token, accessToken);
                }
            }
        } else {
            this.clearState();
            authentication = this.authenticateAndUpdateCache(request, response, null, null);
            token = (String)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("access_token", 0);
            if (token != null) {
                request.setAttribute("access_token", (Object)token);
                request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
                request.setAttribute("id_token", RequestContextHolder.getRequestAttributes().getAttribute("id_token", 0));
                request.setAttribute("refresh_token", RequestContextHolder.getRequestAttributes().getAttribute("refresh_token", 0));
            }
        }
        return authentication;
    }

    private TokenDetails tokenDetails(Authentication authentication) {
        Object details = authentication.getDetails();
        if (details instanceof TokenDetails) {
            return (TokenDetails)details;
        }
        return null;
    }

    private Authentication authenticateAndUpdateCache(HttpServletRequest request, HttpServletResponse response, String token, OAuth2AccessToken accessToken) {
        Authentication authentication = this.performOAuthAuthentication(request, response, accessToken);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
            TokenDetails tokenDetails = this.tokenDetails(authentication);
            if (tokenDetails != null) {
                OAuth2AccessToken accessTokenDetails = tokenDetails.getAccessToken();
                if (accessTokenDetails != null) {
                    token = accessTokenDetails.getValue();
                    Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("access_token", (Object)accessTokenDetails.getValue(), 0);
                    if (accessTokenDetails.getRefreshToken() != null && accessTokenDetails.getRefreshToken().getValue() != null) {
                        RequestContextHolder.getRequestAttributes().setAttribute("refresh_token", (Object)accessTokenDetails.getRefreshToken().getValue(), 0);
                    }
                }
                if (tokenDetails.getIdToken() != null) {
                    Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("id_token", (Object)tokenDetails.getIdToken(), 0);
                }
            }
            this.cache.putCacheEntry(token, authentication);
        }
        Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("PROVIDER", (Object)this.configuration.getProvider(), 0);
        return authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearState() {
        OAuth2ClientContext clientContext = this.restTemplate.getOAuth2ClientContext();
        AccessTokenRequest accessTokenRequest = clientContext.getAccessTokenRequest();
        if (accessTokenRequest != null && accessTokenRequest.getStateKey() != null) {
            clientContext.removePreservedState(accessTokenRequest.getStateKey());
        }
        if (accessTokenRequest != null) {
            try {
                accessTokenRequest.remove((Object)"access_token");
            }
            finally {
                SecurityContextHolder.clearContext();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                LOGGER.debug("Cleaned out Session Access Token Request!");
            }
        }
    }

    protected Authentication performOAuthAuthentication(HttpServletRequest request, HttpServletResponse response, OAuth2AccessToken accessToken) {
        LOGGER.debug("About to perform remote authentication.");
        LOGGER.debug("Access Token: {}", (Object)accessToken);
        String principal = null;
        PreAuthenticatedAuthenticationToken result = null;
        try {
            LOGGER.debug("Trying to get the pre-authenticated principal.");
            principal = this.getPreAuthenticatedPrincipal(request, response, accessToken);
        }
        catch (IOException | ServletException e1) {
            LOGGER.error("Error obtaining pre-authenticated principal: {}", (Object)e1.getMessage(), (Object)e1);
        }
        LOGGER.debug("Pre-authenticated principal = {}, trying to authenticate", (Object)principal);
        if (principal != null && !principal.trim().isEmpty()) {
            result = this.createPreAuthentication(principal, request, response);
        }
        return result;
    }

    protected String getPreAuthenticatedPrincipal(HttpServletRequest req, HttpServletResponse resp, OAuth2AccessToken accessToken) throws IOException, ServletException {
        String username;
        LOGGER.debug("Configuring the REST Resource Template");
        this.configureRestTemplate();
        if (accessToken != null && StringUtils.isNotEmpty((CharSequence)accessToken.getValue())) {
            LOGGER.debug("Setting the access token on the OAuth2ClientContext");
            this.restTemplate.getOAuth2ClientContext().setAccessToken(accessToken);
        }
        LOGGER.debug("Setting up OAuth2 Filter services and resource template");
        this.setRestTemplate(this.restTemplate);
        this.setTokenServices(this.tokenServices);
        Authentication authentication = null;
        try {
            OAuth2Authentication oAuth2Authentication;
            Object map;
            authentication = super.attemptAuthentication(req, resp);
            req.setAttribute(OAUTH2_AUTHENTICATION_KEY, (Object)authentication);
            if (authentication instanceof OAuth2Authentication && (map = (oAuth2Authentication = (OAuth2Authentication)authentication).getOAuth2Request().getExtensions().get(OAUTH2_ACCESS_TOKEN_CHECK_KEY)) instanceof Map) {
                req.setAttribute(OAUTH2_ACCESS_TOKEN_CHECK_KEY, map);
            }
            if (authentication != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authenticated OAuth request for principal {}", authentication.getPrincipal());
            }
        }
        catch (Exception e) {
            this.handleOAuthException(e, req, resp);
        }
        String string = username = authentication != null ? SecurityUtils.getUsername((Object)authentication.getPrincipal()) : null;
        if (username != null && username.trim().isEmpty()) {
            username = null;
        }
        return username;
    }

    private void handleOAuthException(Exception e, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (e instanceof UserRedirectRequiredException && this.configuration.isEnableRedirectEntryPoint()) {
            this.handleUserRedirection(req, resp);
        } else if (e instanceof BadCredentialsException || e instanceof ResourceAccessException) {
            if (e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("Error while trying to authenticate to OAuth2 Provider. Cause: ", e.getCause());
            } else if (e instanceof ResourceAccessException) {
                LOGGER.error("Could not authorize OAuth2 Resource due to exception: ", (Throwable)e);
            } else if (e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("If you try to validate credentials against an SSH protected endpoint, you need your server exposed on a secure SSL channel or OAuth2 Provider Certificate to be trusted on your JVM.");
                LOGGER.info("Refer to the GeoServer OAuth2 Plugin Documentation for steps to import SSH certificates.");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Could not authorize OAuth2 Resource due to exception: ", (Throwable)e);
            }
        }
    }

    private void handleUserRedirection(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AccessTokenRequest accessTokenRequest;
        if (req.getRequestURI().contains(this.configuration.getProvider() + "/login")) {
            this.authEntryPoint.commence(req, resp, null);
        } else if (resp.getStatus() != 302 && (accessTokenRequest = this.restTemplate.getOAuth2ClientContext().getAccessTokenRequest()).getPreservedState() != null && accessTokenRequest.getStateKey() != null) {
            accessTokenRequest.remove((Object)"state");
            accessTokenRequest.remove((Object)accessTokenRequest.getStateKey());
            accessTokenRequest.setPreservedState(null);
        }
    }

    protected void configureRestTemplate() {
        AuthorizationCodeResourceDetails details = (AuthorizationCodeResourceDetails)this.restTemplate.getResource();
        details.setClientId(this.configuration.getClientId());
        details.setClientSecret(this.configuration.getClientSecret());
        this.tokenServices.setClientId(this.configuration.getClientId());
        this.tokenServices.setClientSecret(this.configuration.getClientSecret());
        details.setAccessTokenUri(this.configuration.getAccessTokenUri());
        details.setUserAuthorizationUri(this.configuration.getAuthorizationUri());
        details.setPreEstablishedRedirectUri(this.configuration.getRedirectUri());
        this.tokenServices.setCheckTokenEndpointUrl(this.configuration.getCheckTokenEndpointUrl());
        details.setScope(this.parseScopes(Stream.of(this.configuration.getScopes()).collect(Collectors.joining(","))));
    }

    protected List<String> parseScopes(String commaSeparatedScopes) {
        ArrayList scopes = Lists.newArrayList();
        Collections.addAll(scopes, commaSeparatedScopes.split(","));
        return scopes;
    }

    public PreAuthenticatedAuthenticationToken createPreAuthentication(String username, HttpServletRequest request, HttpServletResponse response) {
        String idToken = OAuth2Utils.getIdToken();
        JWTHelper jwtHelper = this.decodeAndValidateIdToken(idToken);
        username = this.remapUsername(username, jwtHelper);
        LOGGER.info("Retrieving user with authorities for username: {}", (Object)username);
        User user = this.retrieveUserWithAuthorities(username, request, response);
        if (user == null) {
            LOGGER.error("User retrieval failed for username: {}", (Object)username);
            return null;
        }
        SimpleGrantedAuthority authority = new SimpleGrantedAuthority("ROLE_" + user.getRole().toString());
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)user, null, Collections.singletonList(authority));
        if (StringUtils.isNotBlank((CharSequence)this.configuration.getGroupsClaim()) || StringUtils.isNotBlank((CharSequence)this.configuration.getRolesClaim())) {
            this.addAuthoritiesFromToken(user, idToken);
        }
        OAuth2AccessToken accessToken = this.restTemplate.getOAuth2ClientContext().getAccessToken();
        authenticationToken.setDetails((Object)new TokenDetails(accessToken, idToken, this.configuration.getBeanName()));
        return authenticationToken;
    }

    protected JWTHelper decodeAndValidateIdToken(String idToken) {
        if (idToken == null) {
            LOGGER.warn("No idToken provided for decoding. Skipping username remapping.");
            return null;
        }
        try {
            return new JWTHelper(idToken);
        }
        catch (Exception e) {
            LOGGER.error("Failed to decode or validate idToken: {}", (Object)idToken, (Object)e);
            return null;
        }
    }

    private String remapUsername(String username, JWTHelper jwtHelper) {
        String uniqueUsername;
        String principalClaim;
        if (jwtHelper != null && StringUtils.isNotBlank((CharSequence)this.configuration.getPrincipalKey()) && StringUtils.isNotBlank((CharSequence)this.configuration.getUniqueUsername()) && StringUtils.isNotBlank((CharSequence)(principalClaim = jwtHelper.getClaim(this.configuration.getPrincipalKey(), String.class))) && StringUtils.equals((CharSequence)username, (CharSequence)principalClaim) && StringUtils.isNotBlank((CharSequence)(uniqueUsername = jwtHelper.getClaim(this.configuration.getUniqueUsername(), String.class)))) {
            LOGGER.info("Username remapped from {} to {} based on idToken claims.", (Object)username, (Object)uniqueUsername);
            return uniqueUsername;
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthoritiesFromToken(User user, String idToken) {
        LOGGER.debug(" --------- OIDC - ID_TOKEN: {}", (Object)idToken);
        JWTHelper helper = new JWTHelper(idToken);
        Role currentRole = user.getRole();
        String rolesClaimName = this.configuration.getRolesClaim();
        Object rawRoles = null;
        if (StringUtils.isNotBlank((CharSequence)rolesClaimName)) {
            rawRoles = helper.getClaim(rolesClaimName, Object.class);
        }
        if (rawRoles != null) {
            List<String> oidcRoles = helper.getClaimAsList(rolesClaimName, String.class);
            Role defaultRole = this.configuration.getAuthenticatedDefaultRole() != null ? this.configuration.getAuthenticatedDefaultRole() : Role.USER;
            Role newRole = this.computeRole(oidcRoles, defaultRole);
            user.setRole(newRole);
            LOGGER.info("User role set from token. {} -> {}", (Object)currentRole, (Object)newRole);
        } else {
            LOGGER.debug("Roles claim '{}' missing in token -> preserving current role: {}", (Object)rolesClaimName, (Object)currentRole);
        }
        List<Object> oidcGroups = Collections.emptyList();
        if (this.configuration.getGroupsClaim() != null) {
            oidcGroups = helper.getClaimAsList(this.configuration.getGroupsClaim(), String.class);
            LOGGER.debug(" --------- OIDC - GROUPS: {}", oidcGroups);
        }
        this.reconcileRemoteGroups(user, new LinkedHashSet<String>(oidcGroups));
        try {
            if (this.userService != null) {
                this.userService.update(user);
            }
        }
        catch (BadRequestServiceEx | NotFoundServiceEx e) {
            LOGGER.error("Updating user with synchronized groups found in claims failed: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (DataIntegrityViolationException e) {
            LOGGER.error("Updating user with synchronized groups found in claims data integrity violation: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            LOGGER.info("User updated with the following groups: {}", (Object)user.getGroups());
        }
    }

    private Role computeRole(List<String> rolesFromToken, Role defaultRole) {
        if (rolesFromToken == null || rolesFromToken.isEmpty()) {
            return defaultRole != null ? defaultRole : Role.USER;
        }
        Role resolved = defaultRole != null ? defaultRole : Role.USER;
        for (String r : rolesFromToken) {
            if (r == null) continue;
            String rr = r.trim();
            if (rr.equalsIgnoreCase(Role.ADMIN.name())) {
                return Role.ADMIN;
            }
            if (!rr.equalsIgnoreCase(Role.GUEST.name())) continue;
            resolved = Role.GUEST;
        }
        return resolved;
    }

    private String normalizeGroupName(String name) {
        if (name == null) {
            return null;
        }
        return this.configuration.isGroupNamesUppercase() ? name.toUpperCase(Locale.ROOT) : name;
    }

    private boolean isRemoteGroupForProvider(UserGroup group, String provider) {
        List attrs = group.getAttributes();
        if (attrs == null) {
            return false;
        }
        for (UserGroupAttribute a : attrs) {
            if (a == null || !SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME.equals(a.getName()) || !provider.equals(a.getValue())) continue;
            return true;
        }
        return false;
    }

    private void reconcileRemoteGroups(User user, Set<String> newGroupNamesRaw) {
        String provider = this.configuration.getProvider();
        if (StringUtils.isBlank((CharSequence)provider)) {
            LOGGER.warn("Provider name is empty; skipping remote group reconciliation.");
            return;
        }
        if (user.getGroups() == null) {
            user.setGroups(new LinkedHashSet());
        }
        Set newGroupNames = newGroupNamesRaw.stream().filter(Objects::nonNull).map(this::normalizeGroupName).collect(Collectors.toCollection(LinkedHashSet::new));
        Set toRemove = user.getGroups().stream().filter(g -> this.isRemoteGroupForProvider((UserGroup)g, provider)).filter(g -> !newGroupNames.contains(this.normalizeGroupName(g.getGroupName()))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (UserGroup g2 : toRemove) {
            try {
                this.userGroupService.deassignUserGroup(user.getId().longValue(), g2.getId().longValue());
                LOGGER.debug("Removed remote group '{}' for provider '{}' from user {}", (Object)g2.getGroupName(), (Object)provider, (Object)user.getId());
            }
            catch (NotFoundServiceEx e) {
                LOGGER.warn("Deassign failed for group '{}' from user {}: {}", (Object)g2.getGroupName(), (Object)user.getId(), (Object)e.getMessage());
            }
        }
        user.getGroups().removeAll(toRemove);
        for (String groupName : newGroupNames) {
            UserGroup group = this.searchGroup(groupName);
            if (group == null) {
                group = this.createUserGroup(groupName);
                LOGGER.debug("Created remote group '{}' (provider={})", (Object)groupName, (Object)provider);
            } else {
                this.updateGroupSourceServiceAttributes(group);
            }
            UserGroup finalGroup = group;
            boolean alreadyAssigned = user.getGroups().stream().anyMatch(g -> Objects.equals(g.getId(), finalGroup.getId()));
            if (alreadyAssigned) continue;
            try {
                this.userGroupService.assignUserGroup(user.getId().longValue(), group.getId().longValue());
                user.getGroups().add(group);
                LOGGER.debug("Assigned user {} to group '{}'", (Object)user.getId(), (Object)groupName);
            }
            catch (NotFoundServiceEx e) {
                LOGGER.error("Assignment of user {} to group '{}' failed: {}", (Object)user.getId(), (Object)groupName, (Object)e.getMessage());
            }
        }
        LinkedHashMap<String, UserGroup> byName = new LinkedHashMap<String, UserGroup>();
        for (UserGroup g3 : user.getGroups()) {
            byName.put(this.normalizeGroupName(g3.getGroupName()), g3);
        }
        user.setGroups(new LinkedHashSet(byName.values()));
    }

    private UserGroup searchGroup(String groupName) {
        UserGroup userGroup;
        if (this.userGroupService == null) {
            return null;
        }
        if (this.configuration.isGroupNamesUppercase() && (userGroup = this.userGroupService.get(groupName.toUpperCase())) != null) {
            return userGroup;
        }
        return this.userGroupService.get(groupName);
    }

    private void updateGroupSourceServiceAttributes(UserGroup group) {
        Optional<UserGroupAttribute> sourceServiceAttribute;
        ArrayList<UserGroupAttribute> attributes = group.getAttributes();
        if (attributes == null) {
            attributes = new ArrayList<UserGroupAttribute>();
            group.setAttributes(attributes);
        }
        if ((sourceServiceAttribute = attributes.stream().filter(attribute -> SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME.equals(attribute.getName())).findFirst()).isPresent()) {
            sourceServiceAttribute.get().setValue(this.configuration.getProvider());
        } else {
            attributes.add(this.createUserGroupSourceServiceAttribute(this.configuration.getProvider()));
        }
        try {
            this.userGroupService.updateAttributes(group.getId().longValue(), attributes);
        }
        catch (NotFoundServiceEx e) {
            LOGGER.warn("Could not persist sourceService attribute for group '{}': {}", (Object)group.getGroupName(), (Object)e.getMessage());
        }
    }

    private UserGroup createUserGroup(String groupName) {
        UserGroup group = new UserGroup();
        group.setGroupName(this.configuration.isGroupNamesUppercase() ? groupName.toUpperCase() : groupName);
        group.setAttributes(List.of(this.createUserGroupSourceServiceAttribute(this.configuration.getProvider())));
        if (this.userGroupService != null) {
            try {
                long groupId = this.userGroupService.insert(group);
                group = this.userGroupService.get(groupId);
                LOGGER.debug("inserted group id: {}", (Object)group.getGroupName());
            }
            catch (BadRequestServiceEx e) {
                LOGGER.error("Saving new group found in claims failed");
            }
        }
        return group;
    }

    private UserGroupAttribute createUserGroupSourceServiceAttribute(String remoteService) {
        UserGroupAttribute userGroupAttribute = new UserGroupAttribute();
        userGroupAttribute.setName(SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME);
        userGroupAttribute.setValue(remoteService);
        return userGroupAttribute;
    }

    protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
        User user = null;
        if (username != null && this.userService != null) {
            try {
                user = this.userService.get(username);
            }
            catch (NotFoundServiceEx notFoundServiceEx) {
                LOGGER.debug("User with username {} not found.", (Object)username);
            }
        }
        if (user == null) {
            try {
                user = this.createUser(username, null, "");
            }
            catch (BadRequestServiceEx | NotFoundServiceEx e) {
                LOGGER.error("Error while auto-creating the user: {}", (Object)username, (Object)e);
            }
        }
        return user;
    }

    protected User createUser(String userName, String credentials, Object rawUser) throws BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(userName);
        user.setNewPassword(credentials);
        user.setEnabled(true);
        UserAttribute userAttribute = new UserAttribute();
        userAttribute.setName("CONFIGURATION_NAME");
        userAttribute.setValue(this.configuration.getBeanName());
        user.setAttribute(Collections.singletonList(userAttribute));
        HashSet groups = new HashSet();
        user.setGroups(groups);
        user.setRole(Role.USER);
        if (this.userService != null && this.configuration.isAutoCreateUser()) {
            long id = this.userService.insert(user);
            user = new User(user);
            user.setId(Long.valueOf(id));
        }
        return user;
    }

    public void afterPropertiesSet() {
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authentication success. Updating SecurityContextHolder to contain: {}", (Object)authResult);
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.addRequestAttributes(request, authResult);
        request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
    }

    private void addRequestAttributes(HttpServletRequest request, Authentication authentication) {
        TokenDetails tokenDetails;
        if (authentication != null && (tokenDetails = this.tokenDetails(authentication)) != null && tokenDetails.getAccessToken() != null) {
            OAuth2AccessToken accessToken = tokenDetails.getAccessToken();
            request.setAttribute("access_token", (Object)accessToken.getValue());
            if (tokenDetails.getIdToken() != null) {
                request.setAttribute("id_token", (Object)tokenDetails.getIdToken());
            }
            if (accessToken.getRefreshToken() != null) {
                request.setAttribute("refresh_token", (Object)accessToken.getRefreshToken().getValue());
            }
            request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (failed instanceof AccessTokenRequiredException) {
            SecurityContextHolder.clearContext();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication request failed:", (Throwable)failed);
                LOGGER.debug("Cleared SecurityContextHolder.");
            }
        }
    }

    public static enum OAuth2AuthenticationType {
        BEARER,
        USER;

    }
}

