/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakUserGroupDAO;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KeycloakUserGroupDAOTest {
    @Rule
    public WireMockRule wireMockServer = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
    private String authService;
    private KeycloakUserGroupDAO userGroupDAO;

    @Before
    public void before() {
        this.authService = "http://localhost:" + this.wireMockServer.port();
        KeycloakAdminClientConfiguration configuration = new KeycloakAdminClientConfiguration();
        configuration.setServerUrl(this.authService);
        configuration.setRealm("master");
        configuration.setUsername("username");
        configuration.setPassword("password");
        configuration.setClientId("clientId");
        this.userGroupDAO = new KeycloakUserGroupDAO(configuration);
        this.wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/realms/master/protocol/openid-connect/token")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_token_response.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/roles")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_roles.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/users/0e72c14e-53d8-4619-a05a-a605dc2102b9/role-mappings/realm/composite")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_user_roles.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/roles?search=create")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_two_roles.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/roles/test-create-group")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_one_role.json")));
    }

    @Test
    public void testGetAll() {
        List groupList = this.userGroupDAO.findAll();
        Assert.assertEquals((long)5L, (long)groupList.size());
    }

    @Test
    public void testSearchNameLike() {
        Search searchCriteria = new Search(User.class);
        searchCriteria.addFilterILike("groupName", "create");
        List groups = this.userGroupDAO.search((ISearch)searchCriteria);
        Assert.assertEquals((long)2L, (long)groups.size());
        List<String> valid = Arrays.asList("test-create-group", "create-realm");
        for (UserGroup ug : groups) {
            Assert.assertTrue((boolean)valid.contains(ug.getGroupName()));
        }
    }

    @Test
    public void testGetOneByName() {
        Search searchCriteria = new Search(User.class);
        searchCriteria.addFilterEqual("groupName", (Object)"test-create-group");
        List groups = this.userGroupDAO.search((ISearch)searchCriteria);
        UserGroup group = (UserGroup)groups.get(0);
        Assert.assertEquals((Object)"test-create-group", (Object)group.getGroupName());
    }

    @Test
    public void testGetOneByName2() {
        UserGroup group = this.userGroupDAO.findByName("test-create-group");
        Assert.assertEquals((Object)"test-create-group", (Object)group.getGroupName());
    }
}

