/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.StoredDataService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.rest.RESTMiscService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ConflictWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RESTMiscServiceImpl
extends RESTServiceImpl
implements RESTMiscService,
ApplicationContextAware {
    private static final Logger LOGGER = LogManager.getLogger(RESTMiscServiceImpl.class);
    private CategoryService categoryService;
    private ResourceService resourceService;
    private StoredDataService storedDataService;
    private ApplicationContext appContext;

    public String getData(SecurityContext sc, String catName, String resName) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getData(" + catName + "," + resName + ")");
        }
        if (catName == null) {
            throw new BadRequestWebEx("Category is null");
        }
        if (resName == null) {
            throw new BadRequestWebEx("Resource is null");
        }
        AndFilter filter = new AndFilter((SearchFilter)new CategoryFilter(catName, SearchOperator.EQUAL_TO), (SearchFilter)new FieldFilter(BaseField.NAME, resName, SearchOperator.EQUAL_TO), new SearchFilter[0]);
        List resources = null;
        try {
            User user = this.extractAuthUser(sc);
            resources = this.resourceService.getResourcesFull(ResourceSearchParameters.builder().filter((SearchFilter)filter).authUser(user).build());
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        catch (InternalErrorServiceEx ex) {
            throw new InternalErrorWebEx(ex.getMessage());
        }
        if (resources.isEmpty()) {
            throw new NotFoundWebEx("No resource found");
        }
        if (resources.size() > 1) {
            throw new ConflictWebEx("Too many resources match the request");
        }
        return ((Resource)resources.get(0)).getData().getData();
    }

    public Resource getResource(SecurityContext sc, String catName, String resName) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResource(" + catName + "," + resName + ")");
        }
        if (catName == null) {
            throw new BadRequestWebEx("Category is null");
        }
        if (resName == null) {
            throw new BadRequestWebEx("Resource is null");
        }
        AndFilter filter = new AndFilter((SearchFilter)new CategoryFilter(catName, SearchOperator.EQUAL_TO), (SearchFilter)new FieldFilter(BaseField.NAME, resName, SearchOperator.EQUAL_TO), new SearchFilter[0]);
        List resources = null;
        try {
            User user = this.extractAuthUser(sc);
            resources = this.resourceService.getResourcesFull(ResourceSearchParameters.builder().filter((SearchFilter)filter).authUser(user).build());
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        catch (InternalErrorServiceEx ex) {
            throw new InternalErrorWebEx(ex.getMessage());
        }
        if (resources.isEmpty()) {
            throw new NotFoundWebEx("No resource found");
        }
        if (resources.size() > 1) {
            throw new ConflictWebEx("Too many resources match the request");
        }
        return (Resource)resources.get(0);
    }

    public ShortResourceList getResourcesByCategory(SecurityContext sc, String catName) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx {
        Category category;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResourcesByCategory(" + catName + ")");
        }
        if (catName == null) {
            throw new BadRequestWebEx("Category is null");
        }
        try {
            category = this.categoryService.get(catName);
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        if (category == null) {
            throw new NotFoundWebEx("Category not found");
        }
        CategoryFilter filter = new CategoryFilter(catName, SearchOperator.EQUAL_TO);
        List resources = null;
        try {
            User user = this.extractAuthUser(sc);
            resources = this.resourceService.getShortResources(ResourceSearchParameters.builder().filter((SearchFilter)filter).authUser(user).build());
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        catch (InternalErrorServiceEx ex) {
            throw new InternalErrorWebEx(ex.getMessage());
        }
        return new ShortResourceList(resources);
    }

    public ResourceList getResourcesByCategory(SecurityContext sc, String catName, boolean includeAttributes, boolean includeData) throws NotFoundWebEx, ConflictWebEx, BadRequestWebEx, InternalErrorWebEx {
        Category category;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResourcesByCategory(" + catName + ")");
        }
        if (catName == null) {
            throw new BadRequestWebEx("Category is null");
        }
        try {
            category = this.categoryService.get(catName);
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        if (category == null) {
            throw new NotFoundWebEx("Category not found");
        }
        CategoryFilter filter = new CategoryFilter(catName, SearchOperator.EQUAL_TO);
        List resources = null;
        try {
            User user = this.extractAuthUser(sc);
            resources = this.resourceService.getResources(ResourceSearchParameters.builder().filter((SearchFilter)filter).includeAttributes(includeAttributes).includeData(includeData).authUser(user).build());
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        catch (InternalErrorServiceEx ex) {
            throw new InternalErrorWebEx(ex.getMessage());
        }
        return new ResourceList(resources);
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @Override
    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setStoredDataService(StoredDataService storedDataService) {
        this.storedDataService = storedDataService;
    }

    public void reload(SecurityContext sc, String service) throws BadRequestWebEx {
        Object reloadService = service;
        if (this.appContext != null) {
            if (!this.appContext.containsBean((String)reloadService)) {
                reloadService = (String)reloadService + "Initializer";
            }
            if (!this.appContext.containsBean((String)reloadService)) {
                throw new BadRequestWebEx("No service named " + service + " to reload");
            }
            InitializingBean bean = (InitializingBean)this.appContext.getBean((String)reloadService, InitializingBean.class);
            if (bean != null) {
                try {
                    bean.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new BadRequestWebEx(e.getMessage());
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }
}

