/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.services.rest.security.keycloak.BaseKeycloakDAO;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.RoleRepresentation;

public class KeycloakUserGroupDAO
extends BaseKeycloakDAO
implements UserGroupDAO {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakUserGroupDAO.class);
    private boolean addEveryOneGroup = false;

    public KeycloakUserGroupDAO(KeycloakAdminClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    static UserGroup everyoneGroup(int id) {
        UserGroup everyoneGroup = new UserGroup();
        everyoneGroup.setGroupName(GroupReservedNames.EVERYONE.groupName());
        everyoneGroup.setEnabled(true);
        everyoneGroup.setId(Long.valueOf(id));
        return everyoneGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserGroup> findAll() {
        Keycloak keycloak = this.keycloak();
        try {
            List roleRepresentations = this.getRolesResource(keycloak).list();
            List<UserGroup> list = this.toUserGroups(roleRepresentations, true);
            return list;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No users were found", (Throwable)e);
            List<UserGroup> list = null;
            return list;
        }
        finally {
            this.close(keycloak);
        }
    }

    public UserGroup find(Long id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(UserGroup ... userGroups) {
        Keycloak keycloak = this.keycloak();
        try {
            for (UserGroup group : userGroups) {
                RoleRepresentation roleRepresentation = this.toRoleRepresentation(group);
                this.getRolesResource(keycloak).create(roleRepresentation);
                group.setId(Long.valueOf(-1L));
            }
        }
        finally {
            this.close(keycloak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup[] save(UserGroup ... userGroups) {
        Keycloak keycloak = this.keycloak();
        try {
            for (UserGroup group : userGroups) {
                RoleRepresentation roleRepresentation = this.toRoleRepresentation(group);
                this.getRolesResource(keycloak).create(roleRepresentation);
                group.setId(Long.valueOf(-1L));
            }
            UserGroup[] userGroupArray = userGroups;
            return userGroupArray;
        }
        finally {
            this.close(keycloak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup merge(UserGroup userGroup) {
        Keycloak keycloak = this.keycloak();
        try {
            RoleRepresentation roleRepresentation = new RoleRepresentation();
            roleRepresentation.setName(userGroup.getGroupName());
            roleRepresentation.setDescription(userGroup.getDescription());
            this.getRolesResource(keycloak).get(userGroup.getGroupName()).update(roleRepresentation);
            userGroup.setId(Long.valueOf(-1L));
            UserGroup userGroup2 = userGroup;
            return userGroup2;
        }
        finally {
            this.close(keycloak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(UserGroup userGroup) {
        Keycloak keycloak = this.keycloak();
        try {
            this.getRolesResource(keycloak).get(userGroup.getGroupName()).remove();
            boolean bl = true;
            return bl;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No user found with name {}", (Object)userGroup.getGroupName(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(keycloak);
        }
    }

    public boolean removeById(Long id) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserGroup> search(ISearch search) {
        Keycloak keycloak = this.keycloak();
        try {
            List<RoleRepresentation> roles;
            KeycloakQuery query = this.toKeycloakQuery(search);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing the following Keycloak query {}", (Object)query.toString());
            }
            RolesResource rr = this.getRolesResource(keycloak);
            String groupName = query.getGroupName();
            if (groupName != null && !query.isExact()) {
                roles = rr.list(groupName, query.getStartIndex(), query.getMaxResults());
            } else if (groupName != null && query.isExact()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing exact query");
                }
                RoleRepresentation representation = GroupReservedNames.EVERYONE.groupName().equals(groupName) && query.getSkipEveryBodyGroup() == false ? this.everyoneRoleRep() : rr.get(groupName).toRepresentation();
                roles = Collections.singletonList(representation);
            } else {
                roles = rr.list(query.getStartIndex(), query.getMaxResults());
            }
            List<UserGroup> list = this.toUserGroups(roles, query.getSkipEveryBodyGroup() == false);
            return list;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No groups were found", (Throwable)e);
            List<UserGroup> list = null;
            return list;
        }
        finally {
            this.close(keycloak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(ISearch search) {
        Keycloak keycloak = this.keycloak();
        try {
            KeycloakQuery query = this.toKeycloakQuery(search);
            RolesResource rr = this.getRolesResource(keycloak);
            int count = query.getUserName() != null && query.isExact() ? 1 : (query.getUserName() != null ? rr.list(query.getUserName(), true).size() : rr.list().size());
            if (this.isAddEveryOneGroup()) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No groups were found", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.close(keycloak);
        }
    }

    private List<UserGroup> toUserGroups(List<RoleRepresentation> roleRepresentations, boolean isEveryoneRequested) {
        ArrayList<UserGroup> groups = new ArrayList<UserGroup>(roleRepresentations.size());
        int counter = 1;
        for (RoleRepresentation role : roleRepresentations) {
            GeoStoreKeycloakAuthoritiesMapper mapper = this.getAuthoritiesMapper();
            mapper.mapAuthorities(Collections.singletonList(role.getName()));
            if (mapper.getGroups() == null || mapper.getGroups().isEmpty()) continue;
            UserGroup group = new UserGroup();
            group.setGroupName(role.getName());
            group.setDescription(role.getDescription());
            group.setEnabled(true);
            group.setId(Long.valueOf(counter));
            groups.add(group);
            ++counter;
        }
        this.addEveryOne(groups, isEveryoneRequested, counter);
        return groups;
    }

    private RoleRepresentation toRoleRepresentation(UserGroup group) {
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName(group.getGroupName());
        roleRepresentation.setDescription(group.getDescription());
        return roleRepresentation;
    }

    public boolean isAddEveryOneGroup() {
        return this.addEveryOneGroup;
    }

    public void setAddEveryOneGroup(boolean addEveryOneGroup) {
        this.addEveryOneGroup = addEveryOneGroup;
    }

    private void addEveryOne(List<UserGroup> groups, boolean addEveryOneGroup, int id) {
        boolean found = groups.stream().anyMatch(g -> g.getGroupName().equals(GroupReservedNames.EVERYONE.groupName()));
        if (!found && addEveryOneGroup && this.isAddEveryOneGroup()) {
            UserGroup everyoneGroup = KeycloakUserGroupDAO.everyoneGroup(id);
            groups.add(everyoneGroup);
        }
    }

    private RoleRepresentation everyoneRoleRep() {
        RoleRepresentation roleRepresentation = new RoleRepresentation();
        roleRepresentation.setName(GroupReservedNames.EVERYONE.groupName());
        return roleRepresentation;
    }

    public UserGroup findByName(String name) {
        Search searchCriteria = new Search(UserGroup.class);
        searchCriteria.addFilterEqual("groupName", (Object)name);
        UserGroup result = null;
        List<UserGroup> existingGroups = this.search((ISearch)searchCriteria);
        if (!existingGroups.isEmpty()) {
            result = existingGroups.get(0);
        }
        return result;
    }

    public UserGroup findWithAttributes(long id) {
        return this.find(id);
    }
}

