/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.MockLdapAuthenticator;
import it.geosolutions.geostore.services.rest.security.MockLdapAuthoritiesPopulator;
import it.geosolutions.geostore.services.rest.security.UserLdapAuthenticationProvider;
import it.geosolutions.geostore.services.rest.utils.MockedUserGroupService;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.util.ReflectionTestUtils;

public class UserLdapAuthenticationProviderTest {
    private static final String TEST_GROUP = "testgroup";
    private UserLdapAuthenticationProvider provider;
    private MockedUserService userService;
    private MockedUserGroupService userGroupService;

    @Before
    public void setUp() {
        this.provider = new UserLdapAuthenticationProvider((LdapAuthenticator)new MockLdapAuthenticator(), (LdapAuthoritiesPopulator)new MockLdapAuthoritiesPopulator(){

            @Override
            public Set<GrantedAuthority> getAllGroups() {
                return Collections.singleton(new SimpleGrantedAuthority(UserLdapAuthenticationProviderTest.TEST_GROUP));
            }
        });
        this.userService = new MockedUserService();
        this.userGroupService = new MockedUserGroupService();
        this.provider.setUserService((UserService)this.userService);
        this.provider.setUserGroupService((UserGroupService)this.userGroupService);
    }

    @Test
    public void testNullPassword() throws NotFoundServiceEx {
        this.provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        User user = this.userService.get("user");
        Assert.assertNotNull((Object)user);
        Assert.assertNull((Object)user.getPassword());
    }

    @Test
    public void testSynchronizeGroups() throws BadRequestServiceEx {
        Assert.assertNull((Object)this.userGroupService.get(TEST_GROUP));
        this.provider.synchronizeGroups();
        Assert.assertNotNull((Object)this.userGroupService.get(TEST_GROUP));
    }

    @Test
    public void testIgnoreUsernameCase() throws NotFoundServiceEx {
        ReflectionTestUtils.setField((Object)this.provider, (String)"ignoreUsernameCase", (Object)true);
        this.provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        User user = this.userService.get("USER");
        Assert.assertNotNull((Object)user);
    }

    @Test
    public void ignoreUsernameCase_isBoundFromProps() {
        try (AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();){
            TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableApplicationContext)ctx, (String[])new String[]{"geostoreLdapProvider.ignoreUsernameCase=true"});
            ctx.register(new Class[]{AppConfigThatDefinesProviderBean.class});
            ctx.refresh();
            UserLdapAuthenticationProvider p = (UserLdapAuthenticationProvider)ctx.getBean(UserLdapAuthenticationProvider.class);
            boolean v = (Boolean)ReflectionTestUtils.getField((Object)p, (String)"ignoreUsernameCase");
            Assert.assertTrue((boolean)v);
        }
    }

    @Configuration
    @PropertySource(value={"classpath:geostore-ovr.properties"})
    public static class AppConfigThatDefinesProviderBean {
        @Bean
        public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
            return new PropertySourcesPlaceholderConfigurer();
        }

        @Bean
        public UserLdapAuthenticationProvider userLdapAuthenticationProvider() {
            UserLdapAuthenticationProvider p = new UserLdapAuthenticationProvider((LdapAuthenticator)new MockLdapAuthenticator(), (LdapAuthoritiesPopulator)new MockLdapAuthoritiesPopulator(){

                @Override
                public Set<GrantedAuthority> getAllGroups() {
                    return Collections.singleton(new SimpleGrantedAuthority(UserLdapAuthenticationProviderTest.TEST_GROUP));
                }
            });
            p.setUserService((UserService)new MockedUserService());
            p.setUserGroupService((UserGroupService)new MockedUserGroupService());
            return p;
        }
    }
}

