/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.impl.RESTSessionServiceImpl;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakHelper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakSessionServiceDelegate;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTestSupport;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class KeycloakSessionServiceTest
extends KeycloakTestSupport {
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String ACCESS_TOKEN = "access_token";
    private static WireMockServer keycloakService;
    private KeyCloakHelper helper;

    @BeforeClass
    public static void mockServerSetup() {
        keycloakService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(12345).notifier((Notifier)new ConsoleNotifier(true)));
        keycloakService.start();
        keycloakService.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/master/protocol/openid-connect/token")).withRequestBody(WireMock.containing((String)"grant_type=refresh_token")).withRequestBody(WireMock.containing((String)"client_id=nginx-authn")).withRequestBody(WireMock.containing((String)"client_secret=nginx-secret")).withRequestBody(WireMock.containing((String)"refresh_token=refresh_token")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("token_response_keycloak.json")));
        keycloakService.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/master/protocol/openid-connect/logout")).withRequestBody(WireMock.containing((String)"client_id=nginx-authn")).withRequestBody(WireMock.containing((String)"client_secret=nginx-secret")).withRequestBody(WireMock.containing((String)"refresh_token=refresh_token")).willReturn(WireMock.aResponse().withStatus(204)));
        keycloakService.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/master/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("keycloak_discovery.json")));
    }

    @AfterClass
    public static void afterClass() {
        keycloakService.stop();
    }

    @Before
    public void setUp() {
        KeyCloakHelper helper;
        this.setUpAdapter("https://cas.core.maui.mda.ca:8040/auth");
        this.adapterConfig.setAuthServerUrl("http://localhost:" + keycloakService.port() + "/auth");
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
        AdapterDeploymentContext context = new AdapterDeploymentContext(deployment);
        this.helper = helper = new KeyCloakHelper(context);
    }

    @Test
    public void testRefreshToken() throws JsonProcessingException, ParseException {
        KeyCloakConfiguration configuration = this.createConfiguration();
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        KeycloakTokenDetails details = new KeycloakTokenDetails(ACCESS_TOKEN, REFRESH_TOKEN, 0L);
        authenticationToken.setDetails((Object)details);
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        try (MockedStatic utilities = Mockito.mockStatic(GeoStoreContext.class);){
            utilities.when(() -> GeoStoreContext.bean(KeyCloakConfiguration.class)).thenReturn((Object)configuration);
            utilities.when(() -> GeoStoreContext.bean(KeyCloakHelper.class)).thenReturn((Object)this.helper);
            utilities.when(() -> GeoStoreContext.bean((String)"keycloakCache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"keycloak", 0);
            attributes.setAttribute(ACCESS_TOKEN, (Object)ACCESS_TOKEN, 0);
            attributes.setAttribute(REFRESH_TOKEN, (Object)REFRESH_TOKEN, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new KeycloakSessionServiceDelegate((RESTSessionService)sessionService, null);
            SessionToken token = new SessionToken();
            token.setTokenType("Bearer");
            token.setAccessToken(ACCESS_TOKEN);
            token.setRefreshToken(REFRESH_TOKEN);
            token.setExpires(Long.valueOf(0L));
            SessionToken result = sessionService.refresh(token);
            Assert.assertEquals((Object)"new_access_token", (Object)result.getAccessToken());
            Assert.assertEquals((Object)"new_refresh_token", (Object)result.getRefreshToken());
        }
    }

    @Test
    public void testGetUser() throws JsonProcessingException, ParseException {
        KeyCloakConfiguration configuration = this.createConfiguration();
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        KeycloakTokenDetails details = new KeycloakTokenDetails(ACCESS_TOKEN, REFRESH_TOKEN, 0L);
        authenticationToken.setDetails((Object)details);
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        try (MockedStatic utilities = Mockito.mockStatic(GeoStoreContext.class);){
            utilities.when(() -> GeoStoreContext.bean(KeyCloakConfiguration.class)).thenReturn((Object)configuration);
            utilities.when(() -> GeoStoreContext.bean(KeyCloakHelper.class)).thenReturn((Object)this.helper);
            utilities.when(() -> GeoStoreContext.bean((String)"keycloakCache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"keycloak", 0);
            attributes.setAttribute(ACCESS_TOKEN, (Object)ACCESS_TOKEN, 0);
            attributes.setAttribute(REFRESH_TOKEN, (Object)REFRESH_TOKEN, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new KeycloakSessionServiceDelegate((RESTSessionService)sessionService, null);
            User user = sessionService.getUser(ACCESS_TOKEN, false);
            Assert.assertEquals((Object)"user", (Object)user.getName());
        }
    }

    @Test
    public void testLogout() throws JsonProcessingException, ParseException {
        KeyCloakConfiguration configuration = this.createConfiguration();
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)"user", (Object)"", new ArrayList());
        KeycloakTokenDetails details = new KeycloakTokenDetails(ACCESS_TOKEN, REFRESH_TOKEN, 0L);
        authenticationToken.setDetails((Object)details);
        TokenAuthenticationCache cache = new TokenAuthenticationCache();
        cache.putCacheEntry(ACCESS_TOKEN, (Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        try (MockedStatic utilities = Mockito.mockStatic(GeoStoreContext.class);){
            utilities.when(() -> GeoStoreContext.bean(KeyCloakConfiguration.class)).thenReturn((Object)configuration);
            utilities.when(() -> GeoStoreContext.bean(KeyCloakHelper.class)).thenReturn((Object)this.helper);
            utilities.when(() -> GeoStoreContext.bean((String)"keycloakCache", TokenAuthenticationCache.class)).thenReturn((Object)cache);
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setParameter(ACCESS_TOKEN, ACCESS_TOKEN);
            request.setUserPrincipal((Principal)authenticationToken);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
            attributes.setAttribute("PROVIDER", (Object)"keycloak", 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            RESTSessionServiceImpl sessionService = new RESTSessionServiceImpl();
            new KeycloakSessionServiceDelegate((RESTSessionService)sessionService, null);
            sessionService.removeSession();
            Assert.assertEquals((long)response.getStatus(), (long)200L);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            Assert.assertNull((Object)request.getUserPrincipal());
        }
    }
}

