/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.enums.DataType;
import java.io.Serializable;
import java.util.Date;

public class ShortAttribute
implements Serializable {
    private static final long serialVersionUID = -2866828937413755002L;
    private String name;
    private String value;
    private DataType type;

    public ShortAttribute() {
    }

    public ShortAttribute(Attribute attribute) {
        this.name = attribute.getName();
        this.value = attribute.getValue();
        this.type = attribute.getType();
    }

    public ShortAttribute(String name, String value, DataType type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public static ShortAttribute createDateAttribute(String name, Date date) {
        return new ShortAttribute(name, Attribute.DATE_FORMAT.format(date), DataType.DATE);
    }

    public static ShortAttribute createStringAttribute(String name, String text) {
        return new ShortAttribute(name, text, DataType.STRING);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.name != null) {
            builder.append("name=").append(this.name).append(", ");
        }
        if (this.value != null) {
            builder.append("value=").append(this.value).append(", ");
        }
        if (this.type != null) {
            builder.append("type=").append(this.type);
        }
        builder.append(']');
        return builder.toString();
    }
}

