/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.TagDAO;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.services.TagService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedTagNameServiceException;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class TagServiceImpl
implements TagService {
    private static final Logger LOGGER = LogManager.getLogger(TagServiceImpl.class);
    private TagDAO tagDAO;
    private ResourceDAO resourceDAO;

    public void setTagDAO(TagDAO tagDAO) {
        this.tagDAO = tagDAO;
    }

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public long insert(Tag tag) throws BadRequestServiceEx, DuplicatedTagNameServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Tag ... ");
        }
        if (tag == null) {
            throw new BadRequestServiceEx("Tag must be specified");
        }
        this.checkForDuplicates(tag, false);
        this.tagDAO.persist((Object[])new Tag[]{tag});
        return tag.getId();
    }

    public List<Tag> getAll(Integer page, Integer entries, String nameLike) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(Tag.class);
        searchCriteria.addSortAsc("name");
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.tagDAO.search((ISearch)searchCriteria);
    }

    public Tag get(long id) {
        return (Tag)this.tagDAO.find(Long.valueOf(id));
    }

    public long update(long id, Tag tag) throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedTagNameServiceException {
        Tag original = this.get(id);
        if (original == null) {
            throw new NotFoundServiceEx("Tag not found");
        }
        this.checkForDuplicates(tag, true);
        tag.setId(Long.valueOf(id));
        tag.setResources(original.getResources());
        this.tagDAO.merge((Object)tag);
        return id;
    }

    private void checkForDuplicates(Tag tag, boolean isUpdate) throws DuplicatedTagNameServiceException {
        int duplicatesCount = this.tagDAO.count((ISearch)new Search().addFilterEqual("name", (Object)tag.getName()).setMaxResults(1));
        if (duplicatesCount > 0) {
            throw new DuplicatedTagNameServiceException(String.format("Cannot %s the tag: a tag with the same name already exists.", isUpdate ? "update" : "create"));
        }
    }

    public void delete(long id) throws NotFoundServiceEx {
        if (this.get(id) == null || !this.tagDAO.removeById(Long.valueOf(id))) {
            throw new NotFoundServiceEx("Tag not found");
        }
    }

    public long count(String nameLike) {
        Search searchCriteria = new Search(Tag.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.tagDAO.count((ISearch)searchCriteria);
    }

    @Transactional(value="geostoreTransactionManager")
    public void addToResource(long id, long resourceId) throws NotFoundServiceEx {
        Tag tag = this.get(id);
        if (tag == null) {
            throw new NotFoundServiceEx("Tag not found");
        }
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(resourceId));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found");
        }
        tag.getResources().add(resource);
        this.tagDAO.persist((Object[])new Tag[]{tag});
    }

    @Transactional(value="geostoreTransactionManager")
    public void removeFromResource(long id, long resourceId) throws NotFoundServiceEx {
        Tag tag = this.get(id);
        if (tag == null) {
            throw new NotFoundServiceEx("Tag not found");
        }
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(resourceId));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found");
        }
        tag.getResources().remove(resource);
        this.tagDAO.persist((Object[])new Tag[]{tag});
    }
}

