/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.dto.UserSession;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InMemoryUserSessionServiceImpl
implements UserSessionService {
    private Map<String, UserSession> sessions = new ConcurrentHashMap<String, UserSession>();
    private int cleanUpSeconds = 60;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Runnable evictionTask = new Runnable(){

        @Override
        public void run() {
            for (String sessionId : InMemoryUserSessionServiceImpl.this.sessions.keySet()) {
                UserSession session = InMemoryUserSessionServiceImpl.this.sessions.get(sessionId);
                if (!session.isExpired()) continue;
                InMemoryUserSessionServiceImpl.this.removeSession(sessionId);
            }
        }
    };

    public InMemoryUserSessionServiceImpl() {
        this.scheduler.scheduleAtFixedRate(this.evictionTask, this.cleanUpSeconds, this.cleanUpSeconds, TimeUnit.SECONDS);
    }

    public void setCleanUpSeconds(int cleanUpSeconds) {
        this.cleanUpSeconds = cleanUpSeconds;
    }

    public User getUserData(String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            UserSession session = this.sessions.get(sessionId);
            if (session.isExpired()) {
                this.removeSession(sessionId);
                return null;
            }
            return session.getUser();
        }
        return null;
    }

    public void registerNewSession(String sessionId, UserSession session) {
        this.sessions.put(sessionId, session);
    }

    public UserSession registerNewSession(UserSession session) {
        String sessionId = this.createSessionId();
        String refreshToken = this.createSessionId();
        session.setId(sessionId);
        session.setRefreshToken(refreshToken);
        this.registerNewSession(sessionId, session);
        return session;
    }

    private String createSessionId() {
        return UUID.randomUUID().toString();
    }

    public void removeSession(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public void removeAllSessions() {
        this.sessions.clear();
    }

    public boolean isOwner(String sessionId, Object owner) {
        UserSession session = this.sessions.get(sessionId);
        if (session != null) {
            return owner.toString().equals(String.valueOf(session.getUser().getId())) || owner.equals(session.getUser());
        }
        return false;
    }

    public UserSession refreshSession(String sessionId, String refreshToken) {
        if (this.sessions.containsKey(sessionId)) {
            UserSession sess = this.sessions.get(sessionId);
            if (sess != null && sess.getRefreshToken().equals(refreshToken)) {
                sess.refresh();
            }
            return sess;
        }
        return null;
    }

    public String getRefreshToken(String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId).getRefreshToken();
        }
        return null;
    }
}

