/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.FavoriteService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import org.springframework.transaction.annotation.Transactional;

public class FavoriteServiceImpl
implements FavoriteService {
    private UserDAO userDAO;
    private ResourceDAO resourceDAO;

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setResourceDAO(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    @Transactional(value="geostoreTransactionManager")
    public void addFavorite(long userId, long resourceId) throws NotFoundServiceEx {
        User user = (User)this.userDAO.find(Long.valueOf(userId));
        if (user == null) {
            throw new NotFoundServiceEx("User not found");
        }
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(resourceId));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found");
        }
        user.getFavorites().add(resource);
        this.userDAO.persist((Object[])new User[]{user});
    }

    @Transactional(value="geostoreTransactionManager")
    public void removeFavorite(long userId, long resourceId) throws NotFoundServiceEx {
        User user = (User)this.userDAO.find(Long.valueOf(userId));
        if (user == null) {
            throw new NotFoundServiceEx("User not found");
        }
        Resource resource = (Resource)this.resourceDAO.find(Long.valueOf(resourceId));
        if (resource == null) {
            throw new NotFoundServiceEx("Resource not found");
        }
        user.getFavorites().remove(resource);
        this.userDAO.persist((Object[])new User[]{user});
    }
}

