/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import it.geosolutions.geostore.core.dao.IpRangeDAO;
import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.services.IPRangeService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPRangeServiceImpl
implements IPRangeService {
    private static final Logger LOGGER = LogManager.getLogger(IPRangeServiceImpl.class);
    private IpRangeDAO ipRangeDAO;

    public void setIpRangeDAO(IpRangeDAO ipRangeDAO) {
        this.ipRangeDAO = ipRangeDAO;
    }

    public long insert(IPRange ipRange) throws BadRequestServiceEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting IP range...");
        }
        if (ipRange == null) {
            throw new BadRequestServiceEx("IP range must be specified");
        }
        if (ipRange.getCidr() == null) {
            throw new BadRequestServiceEx("CIDR must be specified");
        }
        ipRange.setCidr(this.sanitizeCidr(ipRange.getCidr()));
        this.updateIPRangeBounds(ipRange);
        this.ipRangeDAO.persist((Object[])new IPRange[]{ipRange});
        return ipRange.getId();
    }

    private String sanitizeCidr(String cidr) throws BadRequestServiceEx {
        try {
            String[] parts = cidr.split("/");
            if (parts.length != 2) {
                throw new IllegalArgumentException("invalid format");
            }
            String ip = parts[0].trim();
            String prefix = parts[1].trim();
            String sanitizedIp = Arrays.stream(ip.split("\\.")).map(s -> String.valueOf(Integer.parseInt(s))).collect(Collectors.joining("."));
            String sanitizedCidr = sanitizedIp + "/" + prefix;
            return new IPAddressString(sanitizedCidr).toAddress().toString();
        }
        catch (Exception ex) {
            throw new BadRequestServiceEx("Invalid CIDR: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public List<IPRange> getAll() throws BadRequestServiceEx {
        Search searchCriteria = new Search(IPRange.class);
        searchCriteria.addSortAsc("description");
        return this.ipRangeDAO.search((ISearch)searchCriteria);
    }

    public IPRange get(long id) {
        return (IPRange)this.ipRangeDAO.find(Long.valueOf(id));
    }

    public long update(long id, IPRange ipRange) throws BadRequestServiceEx, NotFoundServiceEx {
        IPRange original = this.get(id);
        if (original == null) {
            throw new NotFoundServiceEx("IP range not found");
        }
        if (ipRange.getCidr() == null) {
            throw new BadRequestServiceEx("CIDR must be specified");
        }
        ipRange.setCidr(this.sanitizeCidr(ipRange.getCidr()));
        this.updateIPRangeBounds(ipRange);
        ipRange.setId(Long.valueOf(id));
        this.ipRangeDAO.merge((Object)ipRange);
        return id;
    }

    private void updateIPRangeBounds(IPRange ipRange) {
        IPAddress cidr = new IPAddressString(ipRange.getCidr()).getAddress().toPrefixBlock();
        ipRange.setIpLow(cidr.getLower().getValue());
        ipRange.setIpHigh(cidr.getUpper().getValue());
    }

    public void delete(long id) throws NotFoundServiceEx {
        if (this.get(id) == null || !this.ipRangeDAO.removeById(Long.valueOf(id))) {
            throw new NotFoundServiceEx("IPRange not found");
        }
    }

    public long count() {
        return this.ipRangeDAO.count((ISearch)new Search(IPRange.class));
    }
}

