/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.ExtCaches;
import it.geosolutions.imageio.utilities.SoftValueHashMap;
import it.geosolutions.imageioimpl.plugins.cog.AzureClient;
import it.geosolutions.imageioimpl.plugins.cog.AzureConfigurationProperties;
import java.util.Map;

public class AzureClientFactory {
    private static final Map<String, AzureClient> asyncClients = new SoftValueHashMap();

    private AzureClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AzureClient getClient(AzureConfigurationProperties configProps) {
        String container = configProps.getContainer();
        Map<String, AzureClient> map = asyncClients;
        synchronized (map) {
            return asyncClients.computeIfAbsent(container, c -> new AzureClient(configProps));
        }
    }

    static {
        ExtCaches.addListener(() -> {
            Map<String, AzureClient> map = asyncClients;
            synchronized (map) {
                asyncClients.clear();
            }
        });
    }
}

