/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.AbstractRangeReader;
import it.geosolutions.imageioimpl.plugins.cog.BlobCache;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GSRangeReader
extends AbstractRangeReader {
    public static final String AUTH_URL_BASE = "https://storage.cloud.google.com";
    public static final String PUBLIC_URL_BASE = "https://storage.googleapis.com";
    private static final Logger LOGGER = Logger.getLogger(GSRangeReader.class.getName());
    private static final int CORE_POOL_SIZE = Integer.getInteger("gs.reader.core.poolsize", 64);
    private static final int MAX_POOL_SIZE = Integer.getInteger("gs.reader.max.poolsize", 128);
    private static final int THREAD_TIMEOUT = Integer.getInteger("gs.reader.timeout.ms", 10000);
    static final ThreadPoolExecutor EXECUTORS = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, THREAD_TIMEOUT, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final BlobId id;
    private Blob blob;

    public GSRangeReader(String uri, int headerLength) {
        this(URI.create(uri), headerLength);
    }

    public GSRangeReader(URI uri, int headerLength) {
        this(new BasicAuthURI(uri), headerLength);
    }

    public GSRangeReader(BasicAuthURI uri, int headerLength) {
        super(uri, headerLength);
        this.id = GSRangeReader.getBlobId(uri.getUri());
    }

    public URL getURL() throws MalformedURLException {
        return new URL("https://storage.cloud.google.com/" + this.id.getBucket() + "/" + this.id.getName());
    }

    public static BlobId getBlobId(URI uri) {
        BlobId id;
        if (uri.getScheme().equals("gs")) {
            id = BlobId.fromGsUtilUri((String)uri.toASCIIString());
        } else if (uri.toASCIIString().startsWith(AUTH_URL_BASE)) {
            String path = uri.toASCIIString().substring(AUTH_URL_BASE.length() + 1);
            int idx = path.indexOf(47);
            String bucket = path.substring(0, idx);
            String key = path.substring(idx + 1);
            id = BlobId.of((String)bucket, (String)key);
        } else if (uri.toASCIIString().startsWith(PUBLIC_URL_BASE)) {
            String path = uri.toASCIIString().substring(PUBLIC_URL_BASE.length() + 1);
            int idx = path.indexOf(47);
            String bucket = path.substring(0, idx);
            String key = path.substring(idx + 1);
            id = BlobId.of((String)bucket, (String)key);
        } else {
            throw new IllegalArgumentException("Don't know how to process GS link: " + uri);
        }
        return id;
    }

    public byte[] fetchHeader() {
        byte[] currentHeader = (byte[])this.data.get((Object)0L);
        if (currentHeader != null) {
            this.headerOffset = currentHeader.length;
        }
        byte[] headerBytes = this.readInternal(this.headerOffset, this.headerLength);
        this.data.put((Object)0L, (Object)headerBytes);
        return headerBytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] readInternal(long readOffset, int readLength) {
        try (ReadChannel channel = this.getBlob().reader(new Blob.BlobSourceOption[0]);){
            ByteBuffer buffer = ByteBuffer.allocate(readLength);
            channel.seek(readOffset);
            int bytesRead = channel.read(buffer);
            buffer.flip();
            byte[] bytes = new byte[bytesRead];
            buffer.get(bytes, 0, bytesRead);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading range, offset " + readOffset + ", length " + readLength, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob getBlob() {
        if (this.blob == null) {
            GSRangeReader gSRangeReader = this;
            synchronized (gSRangeReader) {
                if (this.blob == null) {
                    this.blob = BlobCache.getBlob(this.authUri.getUser(), this.id);
                    if (this.blob == null) {
                        throw new IllegalArgumentException("No blob exist at " + this.id);
                    }
                }
            }
        }
        return this.blob;
    }

    public Map<Long, byte[]> read(Collection<long[]> ranges) {
        return this.read((long[][])ranges.toArray((T[])new long[0][]));
    }

    public byte[] readHeader() {
        LOGGER.fine("reading header");
        byte[] currentHeader = (byte[])HEADERS_CACHE.get(this.uri.toString());
        if (currentHeader != null) {
            return currentHeader;
        }
        byte[] headerBytes = this.readInternal(this.headerOffset, this.headerLength);
        this.data.put((Object)0L, (Object)headerBytes);
        HEADERS_CACHE.put(this.uri.toString(), headerBytes);
        return headerBytes;
    }

    public Map<Long, byte[]> read(long[] ... ranges) {
        ranges = this.reconcileRanges(ranges);
        ConcurrentHashMap<Long, byte[]> values = new ConcurrentHashMap<Long, byte[]>();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < ranges.length; ++i) {
            long[] lArray = ranges[i];
            long rangeStart = lArray[0];
            byte[] dataRange = (byte[])this.data.get((Object)rangeStart);
            if (dataRange == null) {
                Future<?> future = EXECUTORS.submit(() -> {
                    long rangeEnd = range[1];
                    int length = (int)(rangeEnd - rangeStart) + 1;
                    byte[] bytes = this.readInternal(rangeStart, length);
                    this.data.put((Object)rangeStart, (Object)bytes);
                    values.put(rangeStart, bytes);
                });
                futures.add(future);
                continue;
            }
            values.put(rangeStart, dataRange);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read data from Google Storage", e);
            }
        }
        return values;
    }

    protected void awaitCompletion(Map<Long, byte[]> data, Map<Long, CompletableFuture<byte[]>> downloads) {
        boolean stillWaiting = true;
        ArrayList<Long> completed = new ArrayList<Long>(downloads.size());
        while (stillWaiting) {
            boolean allDone = true;
            for (Map.Entry<Long, CompletableFuture<byte[]>> entry : downloads.entrySet()) {
                long key = entry.getKey();
                CompletableFuture<byte[]> future = entry.getValue();
                if (future.isDone()) {
                    if (completed.contains(key)) continue;
                    try {
                        data.put(key, future.get());
                        completed.add(key);
                    }
                    catch (Exception e) {
                        LOGGER.warning("Unable to write data from S3 to the destination ByteBuffer. " + e.getMessage());
                    }
                    continue;
                }
                allDone = false;
            }
            stillWaiting = !allDone;
        }
    }
}

