/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageioimpl.plugins.cog.S3ConfigurationProperties;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

public class S3ClientFactory {
    private static Map<String, S3AsyncClient> s3AsyncClients = new HashMap<String, S3AsyncClient>();

    private S3ClientFactory() {
    }

    public static S3AsyncClient getS3Client(S3ConfigurationProperties configProps) {
        String region = configProps.getRegion();
        if (s3AsyncClients.containsKey(region)) {
            return s3AsyncClients.get(region);
        }
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        String user = configProps.getUser();
        String password = configProps.getPassword();
        if (user != null && password != null) {
            if ("".equals(user) && "".equals(password)) {
                builder.credentialsProvider(() -> AnonymousCredentialsProvider.create().resolveCredentials());
            } else {
                builder.credentialsProvider(() -> AwsBasicCredentials.create((String)user, (String)password));
            }
        } else {
            builder.credentialsProvider(() -> DefaultCredentialsProvider.create().resolveCredentials());
        }
        if (configProps.getEndpoint() != null) {
            Object endpoint = configProps.getEndpoint();
            if (!((String)endpoint).endsWith("/")) {
                endpoint = (String)endpoint + "/";
            }
            builder.endpointOverride(URI.create((String)endpoint));
        }
        if (configProps.getRegion() != null) {
            builder.region(Region.of((String)configProps.getRegion()));
        }
        builder.asyncConfiguration(b -> b.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)S3ClientFactory.getExecutor(configProps)));
        builder.forcePathStyle(Boolean.valueOf(configProps.getForcePathStyle()));
        S3AsyncClient s3AsyncClient = (S3AsyncClient)builder.build();
        s3AsyncClients.put(region, s3AsyncClient);
        return s3AsyncClient;
    }

    protected static ThreadPoolExecutor getExecutor(S3ConfigurationProperties configProps) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(configProps.getCorePoolSize(), configProps.getMaxPoolSize(), (long)configProps.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().threadNamePrefix("sdk-async-response-" + configProps.getRegion()).build());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }
}

