/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.ecw;

import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.stream.input.URIImageInputStreamImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import javax.imageio.stream.IIOByteBuffer;

public class ECWPImageInputStream
implements URIImageInputStream {
    private static final String ECWP_PREFIX = "ecwp://";
    private URIImageInputStreamImpl uriInputStream;

    public ECWPImageInputStream(String ecwpUrl) {
        URI uri;
        if (ecwpUrl == null) {
            throw new NullPointerException("Specified argument is null");
        }
        if (!ecwpUrl.startsWith(ECWP_PREFIX)) {
            throw new IllegalArgumentException("Specified ECWP is not valid");
        }
        try {
            uri = new URI(ecwpUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create a proper stream for the provided input");
        }
        this.uriInputStream = new URIImageInputStreamImpl(uri);
    }

    public ECWPImageInputStream(URI uri) {
        this.uriInputStream = new URIImageInputStreamImpl(uri);
    }

    public URI getUri() {
        return this.uriInputStream.getUri();
    }

    public String getECWPLink() {
        URI uri = this.getUri();
        String ecwp = null;
        if (uri != null) {
            ecwp = uri.toString();
        }
        return ecwp;
    }

    public void close() throws IOException {
        this.uriInputStream.close();
    }

    public void flush() throws IOException {
        this.uriInputStream.flush();
    }

    public void flushBefore(long pos) throws IOException {
        this.uriInputStream.flushBefore(pos);
    }

    public int getBitOffset() throws IOException {
        return this.uriInputStream.getBitOffset();
    }

    public ByteOrder getByteOrder() {
        return this.uriInputStream.getByteOrder();
    }

    public long getFlushedPosition() {
        return this.uriInputStream.getFlushedPosition();
    }

    public long getStreamPosition() throws IOException {
        return this.uriInputStream.getStreamPosition();
    }

    public boolean isCached() {
        return this.uriInputStream.isCached();
    }

    public boolean isCachedFile() {
        return this.uriInputStream.isCachedFile();
    }

    public boolean isCachedMemory() {
        return this.uriInputStream.isCachedMemory();
    }

    public long length() throws IOException {
        return this.uriInputStream.length();
    }

    public void mark() {
        this.uriInputStream.mark();
    }

    public int read() throws IOException {
        return this.uriInputStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.uriInputStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.uriInputStream.read(b, off, len);
    }

    public int readBit() throws IOException {
        return this.uriInputStream.readBit();
    }

    public long readBits(int numBits) throws IOException {
        return this.uriInputStream.readBits(numBits);
    }

    public boolean readBoolean() throws IOException {
        return this.uriInputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.uriInputStream.readByte();
    }

    public void readBytes(IIOByteBuffer buf, int len) throws IOException {
    }

    public char readChar() throws IOException {
        return this.uriInputStream.readChar();
    }

    public double readDouble() throws IOException {
        return this.uriInputStream.readDouble();
    }

    public float readFloat() throws IOException {
        return this.uriInputStream.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
    }

    public void readFully(short[] s, int off, int len) throws IOException {
    }

    public void readFully(char[] c, int off, int len) throws IOException {
    }

    public void readFully(int[] i, int off, int len) throws IOException {
    }

    public void readFully(long[] l, int off, int len) throws IOException {
    }

    public void readFully(float[] f, int off, int len) throws IOException {
    }

    public void readFully(double[] d, int off, int len) throws IOException {
    }

    public int readInt() throws IOException {
        return this.uriInputStream.readInt();
    }

    public String readLine() throws IOException {
        return this.uriInputStream.readLine();
    }

    public long readLong() throws IOException {
        return this.uriInputStream.readLong();
    }

    public short readShort() throws IOException {
        return this.uriInputStream.readShort();
    }

    public String readUTF() throws IOException {
        return this.uriInputStream.readUTF();
    }

    public int readUnsignedByte() throws IOException {
        return this.uriInputStream.readUnsignedByte();
    }

    public long readUnsignedInt() throws IOException {
        return this.uriInputStream.readUnsignedInt();
    }

    public int readUnsignedShort() throws IOException {
        return this.uriInputStream.readUnsignedShort();
    }

    public void reset() throws IOException {
    }

    public void seek(long pos) throws IOException {
    }

    public void setBitOffset(int bitOffset) throws IOException {
    }

    public void setByteOrder(ByteOrder byteOrder) {
    }

    public int skipBytes(int n) throws IOException {
        return this.uriInputStream.skipBytes(n);
    }

    public long skipBytes(long n) throws IOException {
        return this.uriInputStream.skipBytes(n);
    }

    public URI getTarget() {
        return this.uriInputStream.getTarget();
    }

    public Class<URI> getBinding() {
        return URI.class;
    }
}

