/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.RenderedImage;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class Viewer {
    private static final String newLine = System.getProperty("line.separator");

    private Viewer() {
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, index, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, index, true);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, 0, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, 0, true);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_STREAM_METADATA, 0, displayImage);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_STREAM_METADATA, 0, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, index, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, index, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, 0, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, 0, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, index, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, index, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, 0, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, 0, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, index, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, index, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, 0, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, 0, true);
    }

    private static void visualizeWithTextArea(RenderedImage ri, String title, GDALUtilities.MetadataChoice textFields, int index, boolean displayImage) {
        StringBuffer sb = new StringBuffer();
        switch (textFields) {
            case ONLY_IMAGE_METADATA: {
                sb.append("  Image Metadata from ").append(title);
                break;
            }
            case ONLY_STREAM_METADATA: {
                sb.append("  Stream Metadata");
                break;
            }
            case STREAM_AND_IMAGE_METADATA: {
                sb.append("  Metadata from ").append(title);
                break;
            }
            case PROJECT_AND_GEOTRANSF: {
                sb.append("  CRS Information for ").append(title);
                break;
            }
            case EVERYTHING: {
                sb.append(" Additional Information from ").append(title);
            }
        }
        final JFrame frame = new JFrame(title);
        frame.getContentPane().setLayout(new BorderLayout());
        String textPosition = "First";
        if (displayImage) {
            frame.getContentPane().add((Component)new ScrollingImagePanel(ri, 640, 480));
            textPosition = "Before";
        }
        JLabel label = new JLabel(sb.toString());
        frame.getContentPane().add((Component)label, textPosition);
        JTextArea textArea = new JTextArea();
        if (textFields == GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF) {
            textArea.setText(GDALUtilities.buildCRSProperties((RenderedImage)ri, (int)index));
        } else if (textFields != GDALUtilities.MetadataChoice.EVERYTHING) {
            textArea.setText(GDALUtilities.buildMetadataText((RenderedImage)ri, (GDALUtilities.MetadataChoice)textFields, (int)index));
        } else {
            textArea.setText(new StringBuffer(GDALUtilities.buildMetadataText((RenderedImage)ri, (GDALUtilities.MetadataChoice)textFields, (int)index).toString()).append(newLine).append(GDALUtilities.buildCRSProperties((RenderedImage)ri, (int)index)).toString());
        }
        textArea.setEditable(false);
        frame.getContentPane().add(textArea);
        frame.getContentPane().add((Component)new JScrollPane(textArea), "Last");
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
    }
}

