/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.awt.image.RenderedImage;
import org.eclipse.imagen.media.viewer.RenderedImageBrowser;

public final class Viewer {
    private static final String newLine = System.getProperty("line.separator");

    private Viewer() {
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, index, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, index, true);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, 0, displayImage);
    }

    public static void visualizeImageMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_IMAGE_METADATA, 0, true);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_STREAM_METADATA, 0, displayImage);
    }

    public static void visualizeStreamMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.ONLY_STREAM_METADATA, 0, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, index, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, index, true);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, 0, displayImage);
    }

    public static void visualizeBothMetadata(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.STREAM_AND_IMAGE_METADATA, 0, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, index, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, index, true);
    }

    public static void visualizeCRS(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, 0, displayImage);
    }

    public static void visualizeCRS(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.PROJECT_AND_GEOTRANSF, 0, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, index, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, int index) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, index, true);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title, boolean displayImage) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, 0, displayImage);
    }

    public static void visualizeAllInformation(RenderedImage ri, String title) {
        Viewer.visualizeWithTextArea(ri, title, GDALUtilities.MetadataChoice.EVERYTHING, 0, true);
    }

    private static void visualizeWithTextArea(RenderedImage ri, String title, GDALUtilities.MetadataChoice textFields, int index, boolean displayImage) {
        if (displayImage) {
            RenderedImageBrowser.showChainAndWaitOnClose((RenderedImage)ri);
        }
    }
}

