/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2kakadu;

import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReader;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import org.gdal.gdal.gdal;

public class JP2GDALKakaduImageReaderSpi
extends GDALImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.jp2kakadu");
    private static final String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static final String[] extensions = new String[]{"jp2"};
    private static final String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000"};
    static final String version = "1.0";
    static final String description = "Kakadu JP2K (GDAL based) Image Reader, version 1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReader";
    static final String vendorName = "GeoSolutions";
    static final String[] wSN = new String[]{"it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageWriterSpi"};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = new String[]{null};
    static final String[] extraStreamMetadataFormatClassNames = new String[]{null};
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = null;
    static final String nativeImageMetadataFormatClassName = null;
    static final String[] extraImageMetadataFormatNames = new String[]{null};
    static final String[] extraImageMetadataFormatClassNames = new String[]{null};

    public JP2GDALKakaduImageReaderSpi() {
        super(vendorName, version, formatNames, extensions, mimeTypes, readerCN, new Class[]{File.class, FileImageInputStreamExt.class}, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames, Collections.singletonList("JP2KAK"));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("JP2GDALKakaduImageReaderSpi Constructor");
        }
    }

    public boolean canDecodeInput(Object input) throws IOException {
        return super.canDecodeInput(input);
    }

    public ImageReader createReaderInstance(Object source) throws IOException {
        return new JP2GDALKakaduImageReader(this);
    }

    public String getDescription(Locale locale) {
        return description;
    }

    public static final void setKakaduInputErrorManagement(int errorManagement) {
        switch (errorManagement) {
            case 2: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"FAST");
                break;
            }
            case 0: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"FUSSY");
                break;
            }
            case 1: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"RESILIENT");
                break;
            }
            default: {
                throw new IllegalArgumentException("KAKADU_ERROR_LEVEL_MANAGEMENT unknown! Provided value is " + errorManagement);
            }
        }
    }

    public static final void setKakaduInputErrorManagement(KakaduErrorManagementType errorManagement) {
        switch (errorManagement) {
            case FAST: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"FAST");
                break;
            }
            case FUSSY: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"FUSSY");
                break;
            }
            case RESILIENT: {
                gdal.SetConfigOption((String)"KAKADU_ERROR_LEVEL_MANAGEMENT", (String)"RESILIENT");
                break;
            }
            default: {
                throw new IllegalArgumentException("KAKADU_ERROR_LEVEL_MANAGEMENT unknown! Provided value is " + (Object)((Object)errorManagement));
            }
        }
    }

    public static final class KakaduErrorManagement {
        public static final int FUSSY = 0;
        public static final int RESILIENT = 1;
        public static final int FAST = 2;
    }

    public static enum KakaduErrorManagementType {
        FUSSY,
        RESILIENT,
        FAST;

    }
}

