/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.grib1;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.grib1.GRIB1ImageMetadata;
import it.geosolutions.imageio.plugins.grib1.GRIB1Utilities;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseVariableWrapper;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.grib.grib1.GribPDSLevel;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class GRIB1ImageReader
extends BaseImageReader {
    private BaseNetCDFImageReader reader;
    protected static final Logger LOGGER = Logger.getLogger(GRIB1ImageReader.class.toString());
    private Map<String, Variable> boundsMap = new HashMap<String, Variable>();
    private Map<String, CoordinateAxis> coordSysMap = new HashMap<String, CoordinateAxis>();
    private Variable horizontalGrid;
    private HashMap<Range, GribVariableWrapper> indexMap;

    BaseNetCDFImageReader getInnerReader() {
        return this.reader;
    }

    List<NetCDFUtilities.KeyValuePair> getCoordinateAttributes() {
        List<NetCDFUtilities.KeyValuePair> attribs = Collections.emptyList();
        if (this.horizontalGrid != null) {
            List attributes = this.horizontalGrid.getAttributes();
            attribs = new LinkedList<NetCDFUtilities.KeyValuePair>();
            for (Attribute attribute : attributes) {
                String attribName = attribute.getName();
                if (!attribName.startsWith("GRIB_param_")) continue;
                NetCDFUtilities.KeyValuePair kvp = new NetCDFUtilities.KeyValuePair(attribName.substring("GRIB_param_".length()), NetCDFUtilities.getAttributesAsString((Attribute)attribute));
                attribs.add(kvp);
            }
        }
        return attribs;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.reader.setInput(input, seekForwardOnly, ignoreMetadata);
        this.initialize();
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    public void setInput(Object input) {
        this.setInput(input, false, false);
    }

    private synchronized void initialize() {
        int numImages = 0;
        this.indexMap = new HashMap();
        NetcdfDataset dataset = this.reader.getDataset();
        try {
            List variables;
            if (dataset != null && (variables = dataset.getVariables()) != null) {
                for (Variable variable : variables) {
                    if (variable == null || !(variable instanceof VariableDS)) continue;
                    if (!NetCDFUtilities.isVariableAccepted((Variable)variable, (NetCDFUtilities.CheckType)NetCDFUtilities.CheckType.NONE)) {
                        if (!variable.getName().equalsIgnoreCase("latLonCoordSys")) continue;
                        this.horizontalGrid = variable;
                        continue;
                    }
                    int[] shape = variable.getShape();
                    Range wrapperRange = null;
                    switch (shape.length) {
                        case 2: {
                            wrapperRange = new Range(numImages, numImages + 1);
                            this.indexMap.put(wrapperRange, new GribVariableWrapper(variable, wrapperRange));
                            ++numImages;
                            break;
                        }
                        case 3: {
                            wrapperRange = new Range(numImages, numImages + shape[0]);
                            this.indexMap.put(wrapperRange, new GribVariableWrapper(variable, wrapperRange));
                            numImages += shape[0];
                            break;
                        }
                        case 4: {
                            wrapperRange = new Range(numImages, numImages + shape[0] * shape[1]);
                            this.indexMap.put(wrapperRange, new GribVariableWrapper(variable, wrapperRange));
                            numImages += shape[0] * shape[1];
                        }
                    }
                }
            }
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
        }
        this.setNumImages(numImages);
        this.reader.setNumImages(numImages);
        this.reader.setIndexMap(this.indexMap);
    }

    public GRIB1ImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        this.reader = new BaseNetCDFImageReader(originatingProvider);
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.reader.getWidth(imageIndex);
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.reader.getHeight(imageIndex);
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int strideY;
        int strideX;
        BufferedImage image = null;
        Variable variable = null;
        Range indexRange = null;
        GribVariableWrapper wrapper = null;
        for (Range range : this.indexMap.keySet()) {
            if (!range.contains(imageIndex) || range.first() > imageIndex || imageIndex >= range.last()) continue;
            wrapper = this.indexMap.get(range);
            indexRange = range;
            break;
        }
        variable = wrapper.getVariable();
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            srcBands = null;
            dstBands = null;
        }
        int rank = wrapper.getRank();
        int bandDimension = rank - 3;
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        GRIB1ImageReader.computeRegions((ImageReadParam)param, (int)width, (int)height, null, (Rectangle)srcRegion, (Rectangle)destRegion);
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (int i = 0; i < rank; ++i) {
            int length;
            int first;
            int stride = switch (rank - i) {
                case 1 -> {
                    first = srcRegion.x;
                    length = srcRegion.width;
                    yield strideX;
                }
                case 2 -> {
                    first = srcRegion.y;
                    length = srcRegion.height;
                    yield strideY;
                }
                default -> {
                    first = i == bandDimension ? NetCDFUtilities.getZIndex((Variable)variable, (Range)indexRange, (int)imageIndex) : NetCDFUtilities.getTIndex((Variable)variable, (Range)indexRange, (int)imageIndex);
                    length = 1;
                    yield 1;
                }
            };
            try {
                ranges.add(new Range(first, first + length - 1, stride));
                continue;
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
        Section sections = new Section(ranges);
        SampleModel sampleModel = wrapper.getSampleModel().createCompatibleSampleModel(destWidth, destHeight);
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        boolean numDstBands = true;
        int size = destHeight * destWidth * 1;
        for (int zi = 0; zi < 1; ++zi) {
            int dstBand = dstBands == null ? zi : dstBands[zi];
            try {
                Array array = variable.read(sections);
                DataBuffer dataBuffer = null;
                if (array instanceof ArrayByte) {
                    dataBuffer = new DataBufferByte((byte[])array.get1DJavaArray(Byte.TYPE), size);
                } else if (array instanceof ArrayShort) {
                    dataBuffer = new DataBufferShort((short[])array.get1DJavaArray(Short.TYPE), size);
                } else if (array instanceof ArrayInt) {
                    dataBuffer = new DataBufferInt((int[])array.get1DJavaArray(Integer.TYPE), size);
                } else if (array instanceof ArrayFloat) {
                    dataBuffer = new DataBufferFloat((float[])array.get1DJavaArray(Float.TYPE), size);
                } else if (array instanceof ArrayDouble) {
                    dataBuffer = new DataBufferDouble((double[])array.get1DJavaArray(Double.TYPE), size);
                }
                WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
                image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
                continue;
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
        return image;
    }

    public synchronized IIOMetadata getStreamMetadata() {
        throw new UnsupportedOperationException("Stream Metadata are currently unsupported for this reader");
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return new GRIB1ImageMetadata(this, imageIndex);
    }

    public void dispose() {
        super.dispose();
        this.reader.dispose();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return this.reader.getImageTypes(imageIndex);
    }

    class GribVariableWrapper
    extends BaseVariableWrapper {
        private VerticalLevel verticalLevel;
        private String boundName;
        private String paramID;
        private List<CoordinateAxis> axes;
        private String parameterUnit;
        private Range range;
        private int parameterCenterID;
        private int parameterTableVersion;
        private int parameterNumber;
        private String productDefinitionType;
        private String timeUnits;
        private String timeName;
        private String parameterName;

        public GribVariableWrapper(Variable variable, Range range) {
            super(variable);
            this.timeUnits = "";
            this.timeName = "";
            this.range = range;
            int rank = variable.getRank();
            int width = variable.getDimension(rank - 1).getLength();
            int height = variable.getDimension(rank - 2).getLength();
            List dimensions = variable.getDimensions();
            this.axes = new LinkedList<CoordinateAxis>();
            for (Dimension dim : dimensions) {
                String dimName = dim.getName();
                Variable coordinate = GRIB1ImageReader.this.reader.getDataset().findVariable(dimName);
                if (coordinate == null) continue;
                CoordinateAxis axis = (CoordinateAxis)coordinate;
                if (!GRIB1ImageReader.this.coordSysMap.containsKey(dimName)) {
                    GRIB1ImageReader.this.coordSysMap.put(dimName, axis);
                }
                this.axes.add(axis);
                Attribute bounds = coordinate.findAttribute("bounds");
                if (bounds == null) continue;
                String boundName = bounds.getStringValue();
                Variable boundVar = GRIB1ImageReader.this.reader.getDataset().findVariable(boundName);
                if (boundVar == null) continue;
                this.boundName = boundName;
                if (GRIB1ImageReader.this.boundsMap.containsKey(boundName)) continue;
                GRIB1ImageReader.this.boundsMap.put(boundName, boundVar);
            }
            int bufferType = NetCDFUtilities.getRawDataType((VariableIF)variable);
            this.setSampleModel(new BandedSampleModel(bufferType, width, height, 1));
            this.initParam();
            this.initVerticalLevel();
            Variable temporalAxis = this.getTemporalAxis();
            if (temporalAxis != null) {
                this.timeUnits = NetCDFUtilities.getAttributesAsString((Variable)temporalAxis, (String)"units");
                this.timeName = NetCDFUtilities.getAttributesAsString((Variable)temporalAxis, (String)"long_name");
            }
        }

        private void initParam() {
            this.productDefinitionType = NetCDFUtilities.getAttributesAsString((Variable)this.getVariable(), (String)"GRIB_product_definition_type");
            this.parameterName = NetCDFUtilities.getAttributesAsString((Variable)this.getVariable(), (String)"GRIB_param_name");
            this.parameterUnit = NetCDFUtilities.getAttributesAsString((Variable)this.getVariable(), (String)"units");
            this.parameterCenterID = NetCDFUtilities.getAttributesAsNumber((Variable)this.getVariable(), (String)"GRIB_center_id").intValue();
            this.parameterNumber = NetCDFUtilities.getAttributesAsNumber((Variable)this.getVariable(), (String)"GRIB_param_number").intValue();
            this.parameterTableVersion = NetCDFUtilities.getAttributesAsNumber((Variable)this.getVariable(), (String)"GRIB_table_id").intValue();
        }

        private void initVerticalLevel() {
            Variable verticalAxis;
            Number levelNum = NetCDFUtilities.getAttributesAsNumber((Variable)this.getVariable(), (String)"GRIB_level_type");
            int levelType = levelNum != null ? levelNum.intValue() : Integer.MIN_VALUE;
            String levelName = GribPDSLevel.getNameShort((int)levelType);
            String levelUnits = GribPDSLevel.getUnits((int)levelType);
            String levelDescription = GribPDSLevel.getLevelDescription((int)levelType);
            boolean hasExplicitVerticalAxis = !GRIB1Utilities.isVerticalLevelSymbolic(levelType);
            String axisType = "";
            String positive = "";
            if (hasExplicitVerticalAxis && (verticalAxis = this.getVerticalAxis()) != null) {
                axisType = NetCDFUtilities.getAttributesAsString((Variable)verticalAxis, (String)"_CoordinateAxisType");
                positive = NetCDFUtilities.getAttributesAsString((Variable)verticalAxis, (String)"positive");
            }
            this.verticalLevel = new VerticalLevel(levelType, levelName, levelDescription, levelUnits, hasExplicitVerticalAxis, axisType, positive);
        }

        public VerticalLevel getVerticalLevel() {
            return this.verticalLevel;
        }

        public String getProductDefinitionType() {
            return this.productDefinitionType;
        }

        public String getParamID() {
            return this.paramID;
        }

        public String getTimeUnits() {
            return this.timeUnits;
        }

        public String getTimeName() {
            return this.timeName;
        }

        public String getLevelValues(int index) {
            if (!this.getVerticalLevel().isHasExplicitVerticalAxis()) {
                return "";
            }
            int zIndex = NetCDFUtilities.getZIndex((Variable)this.getVariable(), (Range)this.range, (int)index);
            if (this.boundName != null) {
                Variable bound = GRIB1ImageReader.this.boundsMap.get(this.boundName);
                if (bound != null) {
                    int[] shape = bound.getShape();
                    int step = shape[1];
                    String values = GRIB1Utilities.getValuesAsString(bound, new int[]{zIndex * step, zIndex * step + 1});
                    return values;
                }
            } else {
                Variable verticalAxis = this.getVerticalAxis();
                String values = GRIB1Utilities.getValuesAsString(verticalAxis, new int[]{zIndex});
                return values;
            }
            return "";
        }

        public String getTimeValues(int index) {
            Variable temporalAxis = this.getTemporalAxis();
            if (temporalAxis == null) {
                return "";
            }
            int tIndex = NetCDFUtilities.getTIndex((Variable)this.getVariable(), (Range)this.range, (int)index);
            return GRIB1Utilities.getValuesAsString(temporalAxis, new int[]{tIndex});
        }

        private Variable getVerticalAxis() {
            int axesSize = this.axes.size();
            Variable verticalAxis = null;
            verticalAxis = axesSize == 4 ? (Variable)this.axes.get(1) : (Variable)this.axes.get(0);
            return verticalAxis;
        }

        private Variable getTemporalAxis() {
            CoordinateAxis1D axis;
            AxisType axisType;
            int axesSize = this.axes.size();
            Variable temporalAxis = null;
            if (axesSize > 2 && ((axisType = (axis = (CoordinateAxis1D)(temporalAxis = (Variable)this.axes.get(0))).getAxisType()) == AxisType.Time || axisType == AxisType.RunTime)) {
                return axis;
            }
            return temporalAxis;
        }

        public String getParameterUnit() {
            return this.parameterUnit;
        }

        public int getParameterCenterID() {
            return this.parameterCenterID;
        }

        public int getParameterTableVersion() {
            return this.parameterTableVersion;
        }

        public int getParameterNumber() {
            return this.parameterNumber;
        }

        public String getParameterName() {
            return this.parameterName;
        }
    }

    static class VerticalLevel {
        private int levelType;
        private String levelDescription;
        private String levelName;
        private String levelUnits;
        private boolean hasExplicitVerticalAxis;
        private String axisType;
        private String positive;

        public VerticalLevel(int levelType, String levelName, String levelDescription, String levelUnits, boolean hasExplicitVerticalAxis, String axisType, String positive) {
            this.levelType = levelType;
            this.levelDescription = levelDescription;
            this.levelName = levelName;
            this.levelUnits = levelUnits;
            this.hasExplicitVerticalAxis = hasExplicitVerticalAxis;
            this.axisType = axisType;
            this.positive = positive;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public void setLevelType(int levelType) {
            this.levelType = levelType;
        }

        public void setLevelDescription(String levelDescription) {
            this.levelDescription = levelDescription;
        }

        public void setLevelName(String levelName) {
            this.levelName = levelName;
        }

        public void setLevelUnits(String levelUnits) {
            this.levelUnits = levelUnits;
        }

        public void setHasExplicitVerticalAxis(boolean hasExplicitVerticalAxis) {
            this.hasExplicitVerticalAxis = hasExplicitVerticalAxis;
        }

        public boolean isHasExplicitVerticalAxis() {
            return this.hasExplicitVerticalAxis;
        }

        public int getLevelType() {
            return this.levelType;
        }

        public String getLevelUnits() {
            return this.levelUnits;
        }

        public String getLevelName() {
            return this.levelName;
        }

        public String getLevelDescription() {
            return this.levelDescription;
        }
    }
}

